// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                     PXA250 Timer Interrupt Example
//
// Description
// -----------
// This example demonstrates setting up interrupt handlers and timers.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/PXA250.h>

#define TIMER0_INT 26
#define TIMER1_INT 27

#define CORE_CLOCK_FREQUENCY 3686400

static int timerCount;

static void
ledInit()
{
  GPDR0 |= 0x18;
}

static void
ledOn()
{
  GPCR0 = 0x18;
}

static void
ledOff()
{
  GPSR0 = 0x18;
}

void irq_handler(void) __attribute__ ((interrupt ("IRQ")));

void
irq_handler(void)
{
  OSMR0 = OSCR + CORE_CLOCK_FREQUENCY;
  timerCount++;
  if (timerCount & 1)
    GPCR0 = 0x18;
  else
    GPSR0 = 0x18;
  OSSR = 1; /* Clear the timer interrupt */
}

int
main(void)
{
  ledInit();

  ICLR &= ~(1 << TIMER0_INT); /* Timer interrupt generates IRQ interrupts */
  ICMR |= 1 << TIMER0_INT; /* Unmask the timer interrupt */

  OSMR0 = OSCR + CORE_CLOCK_FREQUENCY;
  OIER |= 1; /* Enable OSMR0 match interrupt */

  /* Enable Interrupts */
  __ARMLIB_enableIRQ();
  
  while (timerCount < 5);

  return 0; 
}
