// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "test.h"
#include <ctl_api.h>
#include <targets/TMS470.h>

#define RTI_CMP2_INT 1
#define RTI_CMP1_INT 2

unsigned long idleCount;

static CTL_ISR_FN_t userTimerISR;

static void
timerISR(void)
{
  RTICINT &= ~0x80; /* Clear CM1 flag */
  RTICMP1 += 1000; /* Setup the next CMP1 interrupt */
  userTimerISR();
}

void
SetTimerISR(CTL_ISR_FN_t isr)
{
  RTIPCTL = 11; /* Clock timer counter at 1Mhz */
  RTICINT |= 0x20; /* Enable CMP1 interrupt */
  RTICMP1 = 1000; /* Setup initial CMP1 interrupt */
  RTICNTR &= 0x0000FFFF; /* Reset the counter */
  userTimerISR = isr;
  ctl_set_isr(RTI_CMP1_INT, 0, CTL_ISR_TRIGGER_FIXED, timerISR, 0);
  ctl_unmask_isr(RTI_CMP1_INT);
}

void
Idle()
{
  ++idleCount;
}
