/*=============================< uart1.h >===================================*/

#define	BAUD_9600	1
#define 	BAUD_115200	4


/*========================< Function Prototypes >============================*/

/*------------------------------< UartInit >---------------------------------*/
// Sets up UART1 on the LH79520 for serial communications.
// Parameters	:	bBaud		Baud rate - enumerated
// Returns	:		nothing 
void UartInit(BYTE bBaud);

/*-----------------------------< UartDeInit >--------------------------------*/
// Disables UART1.
// Parameters	:	none
// Returns	:		nothing 
void UartDeInit(void); 

/*------------------------------< UartSend >---------------------------------*/
// Writes a Null terminated string to the serial port.
// Parameters	:	string	Pointer to string to send
// Returns	:		nothing 
void UartSend(char *string);

/*----------------------------< UartSendChar >-------------------------------*/
// Sends a single character to the serial port.
// Parameters	:	c			Character to be transmitted
// Returns	:		nothing 
void UartSendChar(char c);

/*-------------------------------< UartGet >---------------------------------*/
// Reads a string from the serial port.  Stops when CR, LF or maxlength occurs.
// Adds Null to end of string.
// Parameters	:	string	Pointer to location to store string.
//						MaxSize	Max Length of string to accept
// Returns	:		nothing 
void UartGet(char *string, char MaxSize);

/*-----------------------------< UartGetKey >--------------------------------*/
// Gets a single character from the serial port.
// Parameters	:	none
// Returns	:		CHAR		Character received
char UartGetKey(void);

/*-------------------------------< UartKey >---------------------------------*/
// Checks to see if a character has been received.
// Parameters	:	none
// Returns	:		CHAR		TRUE if character is available
char UartKey(void);



// end of uart.h
