/*==============================< keytable.h >===============================*/
//
// Copyright Revely Microsystems - Refer documentation for legalese
//
// Last modifed date: 30 Apr 2003 15:37:21
//
/*===========================================================================*/

// Set 2 Make code to ASCII conversion table
//
// Every key is assigned a unique "ASCII" code, simplifying accessing extended
// key functions.  This method and the tables were adapted from R.Burgess' 
// MMURTL code.
// Note : a few keys are unsupported (F11, F12)

const BYTE StdCodes[] = {
	0x00,		// 00 Over-run Error
	0x17,		// 01 F9
	0x00,		// 02 unused
	0x13,		// 03 F5
	0x11,		// 04 F3
	0x0f,		// 05 F1
	0x10,		// 06 F2
	0x00,		// 07 unused
	0x00,		// 08 unused
	0x18,		// 09 F10
	0x16,		// 0a F8
	0x14,		// 0b F6
	0x12,		// 0c F4
	0x09,		// 0d Tab
	0x60,		// 0e `
	0x3d,		// 0f = keypad
	0x00,		// 10 unused
	0x00,		// 11 Left Alt - special
	0x00,		// 12 Left Shift - special
	0x00,		// 13 unused
	0x00,		// 14 Left Ctrl - special
	0x71,		// 15 q
	0x31,		// 16 1
	0x00,		// 17 unused
	0x00,		// 18 unused
	0x00,		// 19 unused
	0x7a,		// 1a z
	0x73,		// 1b s
	0x61,		// 1c a
	0x77,		// 1d	w
	0x32,		// 1e 2
	0x00,		// 1f unused
	0x00,		// 20 unused
	0x63,		// 21 c
	0x78,		// 22 x
	0x64,		// 23 d
	0x65,		// 24 e
	0x34,		// 25 4
	0x33,		// 26 3
	0x00,		// 27 unused
	0x00,		// 28 unused
	0x20,		// 29 Space
	0x76,		// 2a v
	0x66,		// 2b f
	0x74,		// 2c t
	0x72,		// 2d r
	0x35,		// 2e 5
	0x00,		// 2f unused
	0x00,		// 30 unused
	0x6e,		// 31 n
	0x62,		// 32 b
	0x68,		// 33 h
	0x67,		// 34 g
	0x79,		// 35 y
	0x36,		// 36 6
	0x00,		// 37 unused
	0x00,		// 38 unused
	0x00, 	// 39 unused
	0x6d,		// 3a m
	0x6a,		// 3b j
	0x75,		// 3c u
	0x37,		// 3d 7
	0x38,		// 3e 8
	0x00,		// 3f unused
	0x00,		// 40 unused
	0x2c,		// 41 comma
	0x6b,		// 42 k
	0x69,		// 43 i
	0x6f,		// 44 o
	0x30,		// 45 0
	0x39,		// 46 9
	0x00,		// 47 unused
	0x00, 	// 48 unused
	0x2e,		// 49 .
	0x2f,		// 4a /
	0x6c,		// 4b l
	0x3b,		// 4c ;
	0x70,		// 4d p
	0x2d,		// 4e -
	0x00,		// 4f unused
	0x00, 	// 50 unused
	0x00, 	// 51 unused
	0x27,		// 52 '
	0x00,		// 53 unused
	0x5b,		// 54 [
	0x3d,		// 55 =
	0x00,		// 56 unused
	0x00,		// 57 unused
	0x00,		// 58 Caps lock - special
	0x00,		// 59 Right Shift - special
	0x0d, 	// 5a Enter
	0x5d,		// 5b ]
	0x00,		// 5c unused
	0x5c,		// 5d \
	0x00,		// 5e unused
	0x00, 	// 5f unused
	0x00, 	// <<<<<<<<<<<<<<<<< Extra line needed to work-around bug in GCC @#$%!#
	0x00, 	// 60 unused
	0x00, 	// 61 unused	
	0x00, 	// 62 unused
	0x00, 	// 63 unused
	0x00, 	// 64 unused
	0x00, 	// 65 unused
	0x08, 	// 66 Backspace
	0x00, 	// 67 unused
	0x00, 	// 68 unused
	0x8b, 	// 69 Numpad 1 End
	0x00, 	// 6a unused
	0x83,		// 6b Numpad 4 Left
	0x86,		// 6c Numpad 7 Home
	0x00, 	// 6d unused
	0x00, 	// 6e unused
	0x00, 	// 6f unused
	0x8e,		// 70 Numpad 0 Insert
	0xff,		// 71 Numpad . Delete
	0x82,		// 72 Numpad 2 Down
	0x9f,		// 73 Numpad 5
	0x84,		// 74 Numpad 6 Right
	0x81, 	// 75 Numpad 8 Up
	0x1b,		// 76 Escape
	0x00,		// 77 Numlock - special
	0x00,		// 78 unused
	0xab,		// 79 Numpad +
	0x8c,		// 7a Numpad 3 Pg Down
	0xad,		// 7b Numpad -
	0x2a,		// 7c Numpad *
	0x85,		// 7d Numpad 9 Pg Up
	0x00,		// 7e Scroll lock - special
	0x00, 	// 7f unused
	0x00, 	// 80 unused
	0x00, 	// 81 unused
	0x00, 	// 82 unused
	0x15,		// 83 F7
	0x0e,		// 84 Insert (cursor pad)
	0x0b,		// 85 End (cursor pad)
	0x02, 	// 86 Down (cursor pad)
	0x0c, 	// 87 Pg Down (cursor pad)
	0x03,		// 88 Left (cursor pad)
	0x04,		// 89 Right (cursor pad)
	0x06,		// 8a Home (cursor pad)
	0x01,		// 8b Up (cursor pad)
	0x05,		// 8c Pg Up (cursor pad)
	0x7f,		// 8d Delete (cursor pad)

};
	
	
// Table for special E0 codes - 

const BYTE ExtCode[] = 
{
	0x11
};


// This table provides shift level values for ASCII codes from the primary 
// table.
// In Shift-ON state, keycodes 21 - 7E hex are translated through this table.
//	In CAPS LOCK state, codes 61h to 7Ah are translated through this table
//	In NUM LOCK state, codes with High Bit set are translated

const BYTE ShiftCodes[]=
{
 	0x0,		 // 00
  	0x38,		 //  	01  Up   8  Numeric pad
  	0x32,		 //  	02  Dn   2  Numeric pad
  	0x34,		 //  	03  Left 4  Numeric pad
  	0x36,		 //  	04  Right 6  Numeric pad
  	0x39,		 //  	05  PgUp 9  Numeric pad
  	0x37,		 //  	06  Home 7  Numeric pad
  	0x07,		 //  	07
  	0x08,		 //  	08
  	0x09,		 //  	09
  	0x0A,		 //  	0A
  	0x31,		 //  	0B  End  1  Numeric Pad
  	0x33,		 //  	0C  PgDn 3  Numeric pad
  	0x0D,		 //  	0D
  	0x30,		 //  	0E  Ins  0  Numeric pad
  	0x0F,		 //  	0F
  	0x10,		 //  	10
  	0x11,		 //  	11
  	0x12,		 //  	12
  	0x13,		 //  	13
  	0x14,		 //  	14
  	0x15,		 //  	15
  	0x16,		 //  	16
  	0x17,		 //  	17
  	0x18,		 //  	18
  	0x18,		 //  	19
  	0x1A,		 //  	1A
  	0x1B,		 //  	1B
  	0x1C,		 //  	1C
  	0x1D,		 //  	1D
  	0x1E,		 //  	1E
  	0x35,		 //  	1F	Blnk 5  Numeric pad
  	0x20,		 //  	20
  	0x21,		 //  	21
  	0x22,		 //  	22
  	0x23,		 //  	23
  	0x24,		 //  	24
  	0x25,		 //  	25
  	0x26,		 //  	26
  	0x22,		 //  	27  '  "
  	0x28,		 //  	28
  	0x29,		 //  	29
  	0x2A,		 //  	2A
  	0x2B,		 //  	2B
  	0x3C,		 //  	2C  ,  <
  	0x5F,		 //  	2D  -  _
  	0x3E,		 //  	2E  .  >
  	0x3F,		 //  	2F  /  ?
  	0x29,		 //  	30  0  )
  	0x21,		 //  	31  1  !
  	0x40,	 	 //  	32  2  @
  	0x23,	 	 //  	33  3  #
  	0x24,		 //  	34  4  $
  	0x25,	 	 //  	35  5  %
  	0x5E,	 	 //  	36  6  ^
  	0x26,	 	 //  	37  7  &
  	0x2A,	 	 //  	38  8  *
  	0x28,	 	 //  	39  9  (
  	0x3A,	 	 //  	3A
  	0x3A,	 	 //  	3B   //   :
  	0x3C,	 	 //  	3C
  	0x2B,	 	 //  	3D  =  +
  	0x3E,	 	 //  	3E
  	0x3F,	 	 //  	3F
  	0x40,	 	 //  	40
  	0x41,	 	 //  	41
  	0x42,	 	 //  	42
  	0x43,	 	 //  	43
  	0x44,	 	 //  	44
  	0x45,	 	 //  	45
  	0x46,	 	 //  	46
  	0x47,	 	 //  	47
  	0x48,	 	 //  	48
  	0x49,	 	 //  	49
  	0x4A,	 	 //  	4A
  	0x4B,	 	 //  	4B
  	0x4C,	 	 //  	4C
  	0x4D,	 	 //  	4D
  	0x4E,	 	 //  	4E
  	0x4F,	 	 //  	4F
  	0x50,	 	 //  	50
  	0x51,	 	 //  	51
  	0x52,	 	 //  	52
  	0x53,	 	 //  	53
  	0x54,	 	 //  	54
  	0x55,	 	 //  	55
  	0x56,	 	 //  	56
  	0x57,	 	 //  	57
  	0x58,	 	 //  	58
  	0x59,	 	 //  	59
  	0x5A,	 	 //  	5A
  	0x7B,	 	 //  	5B  [  {
  	0x7C,	 	 //  	5C  \  |
  	0x7D,	 	 //  	5D  ]  }
  	0x5E,	 	 //  	5E
  	0x5F,	 	 //  	5F
  	0x7E,	 	 //  	60  `  ~
  	0x41,	 	 //  	61  a  A
  	0x42,	 	 //  	62	b  B
  	0x43,	 	 //  	63	c  C
  	0x44,	 	 //  	64	d  D
  	0x45,	 	 //  	65	e  E
  	0x46,	 	 //  	66	f  F
  	0x47,	 	 //  	67	g  G
  	0x48,	 	 //  	68	h  H
  	0x49,	 	 //  	69	i  I
  	0x4A,	 	 //  	6A	j  J
  	0x4B,	 	 //  	6B	k  K
  	0x4C,	 	 //  	6C	l  L
  	0x4D,	 	 //  	6D	m  M
  	0x4E,	 	 //  	6E	n  N
  	0x4F,	 	 //  	6F	o  O
  	0x50,	 	 //  	70	p  P
  	0x51,	 	 //  	71	q  Q
  	0x52,	 	 //  	72	r  R
  	0x53,	 	 //  	73	s  S
  	0x54,	 	 //  	74	t  T
  	0x55,	 	 //  	75	u  U
  	0x56,	 	 //  	76	v  V
  	0x57,	 	 //  	77  w  W
  	0x58,	 	 //  	78  x  X
  	0x59,	 	 //  	79  y  Y
  	0x5A,	 	 //  	7A  z  Z
  	0x7B,	 	 //  	7B
  	0x7C,	 	 //  	7C
  	0x7D,	 	 //  	7D
  	0x7E,	 	 //  	7E,  	
  	0x2E	 	 //  	7F	Del  .  Numeric Pad
};  	
 // end of keytable.h
