/**********************************************************************
 *	$Workfile:   SMA_graphlib_fonts.c  $
 *	$Revision:   1.2  $
 *	$Author:   lij  $
 *	$Date:   Mar 28 2002 14:25:46  $
 *
 *	Project: SHARP Graphic library
 *
 * Description: This file defines the fonts 
 *
 * Revision History:
 * $Log:   P:/PVCS6_6/archives/LH79520/GraphLib/SMA_graphlib_fonts.c-arc  $
 * 
 *    Rev 1.2   Mar 28 2002 14:25:46   lij
 * Add SHARP Legal Header
 * 
 *    Rev 1.1   Feb 18 2002 21:57:56   lij
 * Modified as per code review on 2/11
 * 
 * 
 *
 * SHARP MICROELECTRONICS OF THE AMERICAS MAKES NO REPRESENTATION
 * OR WARRANTIES WITH RESPECT TO THE PERFORMANCE OF THIS SOFTWARE,
 * AND SPECIFICALLY DISCLAIMS ANY RESPONSIBILITY FOR ANY DAMAGES, 
 * SPECIAL OR CONSEQUENTIAL, CONNECTED WITH THE USE OF THIS SOFTWARE.
 *
 * SHARP MICROELECTRONICS OF THE AMERICAS PROVIDES THIS SOFTWARE SOLELY 
 * FOR THE PURPOSE OF SOFTWARE DEVELOPMENT INCORPORATING THE USE OF A 
 * SHARP MICROCONTROLLER OR SYSTEM-ON-CHIP PRODUCT. USE OF THIS SOURCE
 * FILE IMPLIES ACCEPTANCE OF THESE CONDITIONS.
 *
 *	COPYRIGHT (C) 2001 SHARP MICROELECTRONICS OF THE AMERICAS, INC.
 *		CAMAS, WA
 *********************************************************************/

/* ascii table space thru } */
/* begins and ends with a block to handle overflow */

const BYTE FontBoldTable[1344] = {

/* */   0xFF, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0xFF,  
/* sp*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* ! */ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
/* " */ 0x00, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* # */ 0x00, 0x00, 0x6C, 0x6C, 0xFE, 0x6C, 0x6C, 0x6C, 0xFE, 0x6C, 0x6C, 0x00, 0x00, 0x00,
/* $ */ 0x00, 0x10, 0x7C, 0xD6, 0xD0, 0xD0, 0x7C, 0x16, 0x16, 0xD6, 0x7C, 0x10, 0x00, 0x00,
/* % */ 0x00, 0x00, 0x00, 0x00, 0xC2, 0xC4, 0x08, 0x10, 0x20, 0x46, 0x86, 0x00, 0x00, 0x00,
/* & */ 0x00, 0x00, 0x38, 0x6C, 0x6C, 0x38, 0x76, 0xDC, 0xCC, 0xCC, 0x76, 0x00, 0x00, 0x00,
/* ' */ 0x00, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* ( */ 0x00, 0x00, 0x0C, 0x18, 0x30, 0x30, 0x30, 0x30, 0x30, 0x18, 0x0C, 0x00, 0x00, 0x00,
/* ) */ 0x00, 0x00, 0x30, 0x18, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x18, 0x30, 0x00, 0x00, 0x00,
/* * */ 0x00, 0x00, 0x00, 0x00, 0x66, 0x3C, 0xFF, 0x3C, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
/* + */ 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7E, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
/* , */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x18, 0x30, 0x00, 0x00,
/* - */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* . */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00,
/* / */ 0x00, 0x00, 0x02, 0x06, 0x0C, 0x18, 0x30, 0x60, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00,

/* 0 */ 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xD6, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00,
/* 1 */ 0x00, 0x00, 0x18, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7E, 0x00, 0x00, 0x00,

/* 2 */ 0x00, 0x00, 0x7C, 0xC6, 0x06, 0x0C, 0x18, 0x30, 0x60, 0xC0, 0xFE, 0x00, 0x00, 0x00,
/* 3 */ 0x00, 0x00, 0x7C, 0xC6, 0x06, 0x06, 0x3C, 0x06, 0x06, 0xC6, 0x7C, 0x00, 0x00, 0x00,

/* 4 */ 0x00, 0x00, 0x0C, 0x1C, 0x3C, 0x6C, 0xCC, 0xFE, 0x0C, 0x0C, 0x0C, 0x00, 0x00, 0x00,

/* 5 */ 0x00, 0x00, 0xFE, 0xC0, 0xC0, 0xC0, 0xFC, 0x06, 0x06, 0xC6, 0x7C, 0x00, 0x00, 0x00,

/* 6 */ 0x00, 0x00, 0x3C, 0x60, 0xC0, 0xC0, 0xFC, 0xC6, 0xC6, 0xC6, 0x7E, 0x00, 0x00, 0x00,
/* 7 */ 0x00, 0x00, 0xFE, 0x06, 0x06, 0x0C, 0x18, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00,
/* 8 */ 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0x7C, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00,
/* 9 */ 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0x7E, 0x06, 0x06, 0x0C, 0x78, 0x00, 0x00, 0x00,

/* : */ 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,

/* ; */ 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00,
/* < */ 0x00, 0x00, 0x06, 0x0C, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0C, 0x06, 0x00, 0x00, 0x00,
/* = */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x00,
/* > */ 0x00, 0x00, 0x60, 0x30, 0x18, 0x0C, 0x06, 0x0C, 0x18, 0x30, 0x60, 0x00, 0x00, 0x00,
/* ? */ 0x00, 0x00, 0x7C, 0xC6, 0x06, 0x0C, 0x18, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
/* @ */ 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xDE, 0xDE, 0xDE, 0xDC, 0xC0, 0x7C, 0x00, 0x00, 0x00,
/* A */ 0x00, 0x00, 0x10, 0x38, 0x6C, 0xC6, 0xC6, 0xFE, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00,
/* B */ 0x00, 0x00, 0xFC, 0xC6, 0xC6, 0xC6, 0xFC, 0xC6, 0xC6, 0xC6, 0xFC, 0x00, 0x00, 0x00,
/* C */ 0x00, 0x00, 0x3C, 0x66, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x66, 0x3C, 0x00, 0x00, 0x00,
/* D */ 0x00, 0x00, 0xF8, 0xCC, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xCC, 0xF8, 0x00, 0x00, 0x00,
/* E */ 0x00, 0x00, 0xFE, 0xC0, 0xC0, 0xC0, 0xFC, 0xC0, 0xC0, 0xC0, 0xFE, 0x00, 0x00, 0x00,
/* F */ 0x00, 0x00, 0xFE, 0xC0, 0xC0, 0xC0, 0xFC, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0x00, 0x00,
/* G */ 0x00, 0x00, 0x3C, 0x66, 0xC0, 0xC0, 0xC0, 0xCE, 0xC6, 0x66, 0x3C, 0x00, 0x00, 0x00,
/* H */ 0x00, 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xFE, 0xC6, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00,
/* I */ 0x00, 0x00, 0x3C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3C, 0x00, 0x00, 0x00,
/* J */ 0x00, 0x00, 0x1E, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xCC, 0x78, 0x00, 0x00, 0x00,
/* K */ 0x00, 0x00, 0xC6, 0xCC, 0xD8, 0xF0, 0xE0, 0xF0, 0xD8, 0xCC, 0xC6, 0x00, 0x00, 0x00,
/* L */ 0x00, 0x00, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xFE, 0x00, 0x00, 0x00,
/* M */ 0x00, 0x00, 0xC6, 0xEE, 0xFE, 0xFE, 0xD6, 0xC6, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00,
/* N */ 0x00, 0x00, 0xC6, 0xE6, 0xF6, 0xFE, 0xDE, 0xCE, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00,
/* O */ 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00,
/* P */ 0x00, 0x00, 0xFC, 0xC6, 0xC6, 0xC6, 0xFC, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0x00, 0x00,
/* Q */ 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xD6, 0xCC, 0x7A, 0x00, 0x00, 0x00,
/* R */ 0x00, 0x00, 0xFC, 0xC6, 0xC6, 0xC6, 0xFC, 0xD8, 0xCC, 0xC6, 0xC6, 0x00, 0x00, 0x00,
/* S */ 0x00, 0x00, 0x7C, 0xC6, 0xC0, 0x60, 0x38, 0x0C, 0x06, 0xC6, 0x7C, 0x00, 0x00, 0x00,
/* T */ 0x00, 0x00, 0x7E, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00,
/* U */ 0x00, 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00,
/* V */ 0x00, 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x6C, 0x38, 0x10, 0x00, 0x00, 0x00,
/* W */ 0x00, 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xD6, 0xD6, 0xFE, 0xEE, 0xC6, 0x00, 0x00, 0x00,
/* X */ 0x00, 0x00, 0xC6, 0xC6, 0x6C, 0x38, 0x10, 0x38, 0x6C, 0xC6, 0xC6, 0x00, 0x00, 0x00,
/* Y */ 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00,
/* Z */ 0x00, 0x00, 0xFE, 0x06, 0x0C, 0x18, 0x30, 0x60, 0xC0, 0xC0, 0xFE, 0x00, 0x00, 0x00,
/* [ */ 0x00, 0x00, 0x3C, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3C, 0x00, 0x00, 0x00,
/* \ */ 0x00, 0x00, 0x00, 0x80, 0xC0, 0x60, 0x30, 0x18, 0x0C, 0x06, 0x02, 0x00, 0x00, 0x00,
/* ] */ 0x00, 0x00, 0x3C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x3C, 0x00, 0x00, 0x00,
/* ^ */ 0x10, 0x38, 0x6C, 0xC6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* _ */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00,
/* ` */ 0x30, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* a */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x06, 0x7E, 0xC6, 0xC6, 0x7E, 0x00, 0x00, 0x00,
/* b */ 0x00, 0x00, 0xC0, 0xC0, 0xC0, 0xFC, 0xC6, 0xC6, 0xC6, 0xC6, 0xFC, 0x00, 0x00, 0x00,
/* c */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xC6, 0xC0, 0xC0, 0xC6, 0x7C, 0x00, 0x00, 0x00,
/* d */ 0x00, 0x00, 0x06, 0x06, 0x06, 0x7E, 0xC6, 0xC6, 0xC6, 0xC6, 0x7E, 0x00, 0x00, 0x00,
/* e */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xC6, 0xFE, 0xC0, 0xC6, 0x7C, 0x00, 0x00, 0x00,
/* f */ 0x00, 0x00, 0x3C, 0x66, 0x60, 0x60, 0xF0, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00,
/* g */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0xC6, 0xC6, 0xC6, 0x7E, 0x06, 0x06, 0x7C, 0x00,
/* h */ 0x00, 0x00, 0xC0, 0xC0, 0xC0, 0xFC, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00,
/* i */ 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00,
/* j */ 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0xC6, 0x7C, 0x00,
/* k */ 0x00, 0x00, 0xC0, 0xC0, 0xC0, 0xCC, 0xD8, 0xF0, 0xD8, 0xCC, 0xC6, 0x00, 0x00, 0x00,
/* l */ 0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3C, 0x00, 0x00, 0x00,
/* m */ 0x00, 0x00, 0x00, 0x00, 0x00, 0xEC, 0xD6, 0xD6, 0xD6, 0xD6, 0xC6, 0x00, 0x00, 0x00,
/* n */ 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x00, 0x00, 0x00,
/* o */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00,
/* p */ 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0xC6, 0xC6, 0xC6, 0xC6, 0xFC, 0xC0, 0xC0, 0x00,
/* q */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0xC6, 0xC6, 0xC6, 0xC6, 0x7E, 0x06, 0x06, 0x00,
/* r */ 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0xC6, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, 0x00, 0x00,
/* s */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xC0, 0x70, 0x1C, 0x06, 0x7C, 0x00, 0x00, 0x00,
/* t */ 0x00, 0x00, 0x00, 0x30, 0x30, 0xFC, 0x30, 0x30, 0x30, 0x30, 0x1C, 0x00, 0x00, 0x00,
/* u */ 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00, 0x00,
/* v */ 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6, 0xC6, 0xC6, 0x6C, 0x38, 0x10, 0x00, 0x00, 0x00,
/* w */ 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6, 0xC6, 0xD6, 0xD6, 0xFE, 0xC6, 0x00, 0x00, 0x00,
/* x */ 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6, 0x6C, 0x38, 0x38, 0x6C, 0xC6, 0x00, 0x00, 0x00,
/* y */ 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0x7E, 0x06, 0x06, 0x7C, 0x00,
/* z */ 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x0C, 0x18, 0x30, 0x60, 0xFE, 0x00, 0x00, 0x00,
/* { */ 0x00, 0x00, 0x0E, 0x18, 0x18, 0x18, 0x60, 0x18, 0x18, 0x18, 0x0E, 0x00, 0x00, 0x00,
/* | */ 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00,
/* } */ 0x00, 0x00, 0x70, 0x18, 0x18, 0x18, 0x06, 0x18, 0x18, 0x18, 0x70, 0x00, 0x00, 0x00,
/* */   0xFF, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0xFF,  
	 

 } ;



const BYTE FontTable[1344] = {

/* */   0xFF, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0xFF,  
/* sp*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* ! */ 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
/* " */ 0x00, 0x44, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* # */ 0x00, 0x00, 0x44, 0x44, 0xFE, 0x44, 0x44, 0x44, 0xFE, 0x44, 0x44, 0x00, 0x00, 0x00,
/* $ */ 0x00, 0x10, 0x7C, 0x92, 0x90, 0x90, 0x7C, 0x12, 0x12, 0x92, 0x7C, 0x10, 0x00, 0x00,

/* % */ 0x00, 0x00, 0x00, 0x00, 0x82, 0x84, 0x08, 0x10, 0x20, 0x44, 0x84, 0x00, 0x00, 0x00,
/* & */ 0x00, 0x00, 0x38, 0x44, 0x44, 0x38, 0x52, 0x8C, 0x84, 0x84, 0x72, 0x00, 0x00, 0x00,
/* ' */ 0x00, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* ( */ 0x00, 0x00, 0x08, 0x10, 0x20, 0x20, 0x20, 0x20, 0x20, 0x10, 0x08, 0x00, 0x00, 0x00,
/* ) */ 0x00, 0x00, 0x10, 0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0x10, 0x00, 0x00, 0x00,
/* * */ 0x00, 0x00, 0x00, 0x00, 0x42, 0x28, 0xFF, 0x28, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00,
/* + */ 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7C, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
/* , */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x08, 0x10, 0x00, 0x00,

/* - */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* . */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00,
/* / */ 0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,

/* 0 */ 0x00, 0x00, 0x7C, 0x82, 0x86, 0x8A, 0x92, 0xA2, 0xC2, 0x82, 0x7C, 0x00, 0x00, 0x00,

/* 1 */ 0x00, 0x00, 0x10, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7C, 0x00, 0x00, 0x00,
/* 2 */ 0x00, 0x00, 0x7C, 0x82, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0xFE, 0x00, 0x00, 0x00,
/* 3 */ 0x00, 0x00, 0x7C, 0x82, 0x02, 0x02, 0x3C, 0x02, 0x02, 0x82, 0x7C, 0x00, 0x00, 0x00,
/* 4 */ 0x00, 0x00, 0x0C, 0x14, 0x24, 0x44, 0x84, 0xFE, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00,
/* 5 */ 0x00, 0x00, 0x7E, 0x40, 0x40, 0x40, 0x7C, 0x02, 0x02, 0x42, 0x3C, 0x00, 0x00, 0x00,
/* 6 */ 0x00, 0x00, 0x1C, 0x20, 0x40, 0x40, 0x7C, 0x42, 0x42, 0x42, 0x3C, 0x00, 0x00, 0x00,
/* 7 */ 0x00, 0x00, 0x7E, 0x02, 0x02, 0x04, 0x08, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00,
/* 8 */ 0x00, 0x00, 0x7C, 0x82, 0x82, 0x82, 0x7C, 0x82, 0x82, 0x82, 0x7C, 0x00, 0x00, 0x00,
/* 9 */ 0x00, 0x00, 0x7C, 0x82, 0x82, 0x82, 0x7E, 0x02, 0x02, 0x04, 0x38, 0x00, 0x00, 0x00,
/* : */ 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
/* ; */ 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00,
/* < */ 0x00, 0x00, 0x04, 0x08, 0x10, 0x20, 0x40, 0x20, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00,
/* = */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x00,
/* > */ 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x04, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00,

/* ? */ 0x00, 0x00, 0x78, 0x84, 0x04, 0x08, 0x10, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,

/* @ */ 0x00, 0x00, 0x3C, 0x42, 0x42, 0x4E, 0x4E, 0x4E, 0x4C, 0x40, 0x3C, 0x00, 0x00, 0x00,
/* A */ 0x00, 0x00, 0x10, 0x28, 0x44, 0x82, 0x82, 0xFE, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00,
/* B */ 0x00, 0x00, 0xF8, 0x84, 0x84, 0x84, 0xF8, 0x84, 0x84, 0x84, 0xF8, 0x00, 0x00, 0x00,
/* C */ 0x00, 0x00, 0x3C, 0x42, 0x80, 0x80, 0x80, 0x80, 0x80, 0x42, 0x3C, 0x00, 0x00, 0x00,
/* D */ 0x00, 0x00, 0xF8, 0x84, 0x82, 0x82, 0x82, 0x82, 0x82, 0x84, 0xF8, 0x00, 0x00, 0x00,
/* E */ 0x00, 0x00, 0xFC, 0x80, 0x80, 0x80, 0xF8, 0x80, 0x80, 0x80, 0xFC, 0x00, 0x00, 0x00,
/* F */ 0x00, 0x00, 0xFC, 0x80, 0x80, 0x80, 0xF8, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00,
/* G */ 0x00, 0x00, 0x3C, 0x42, 0x80, 0x80, 0x80, 0x8E, 0x82, 0x42, 0x3C, 0x00, 0x00, 0x00,
/* H */ 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0xFE, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00,
/* I */ 0x00, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00,
/* J */ 0x00, 0x00, 0x1C, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x48, 0x30, 0x00, 0x00, 0x00,
/* K */ 0x00, 0x00, 0x82, 0x84, 0x88, 0x90, 0xE0, 0x90, 0x88, 0x84, 0x82, 0x00, 0x00, 0x00,
/* L */ 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xFC, 0x00, 0x00, 0x00,

/* M */ 0x00, 0x00, 0xC6, 0xAA, 0xAA, 0x92, 0x92, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00,

/* N */ 0x00, 0x00, 0x82, 0xC2, 0xA2, 0x92, 0x8A, 0x86, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00,

/* O */ 0x00, 0x00, 0x7C, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7C, 0x00, 0x00, 0x00,
/* P */ 0x00, 0x00, 0xFC, 0x82, 0x82, 0x82, 0xFC, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00,
/* Q */ 0x00, 0x00, 0x7C, 0x82, 0x82, 0x82, 0x82, 0x82, 0x92, 0x8C, 0x7A, 0x00, 0x00, 0x00,
/* R */ 0x00, 0x00, 0xFC, 0x82, 0x82, 0x82, 0xFC, 0x88, 0x84, 0x82, 0x82, 0x00, 0x00, 0x00,
/* S */ 0x00, 0x00, 0x7C, 0x82, 0x80, 0x40, 0x38, 0x04, 0x02, 0x82, 0x7C, 0x00, 0x00, 0x00,
/* T */ 0x00, 0x00, 0x7C, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00,
/* U */ 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7C, 0x00, 0x00, 0x00,
/* V */ 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x00, 0x00, 0x00,

/* W */ 0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x92, 0xAA, 0xAA, 0xC6, 0x82, 0x00, 0x00, 0x00,

/* X */ 0x00, 0x00, 0x82, 0x82, 0x44, 0x28, 0x10, 0x28, 0x44, 0x82, 0x82, 0x00, 0x00, 0x00,
/* Y */ 0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x38, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00,
/* Z */ 0x00, 0x00, 0xFE, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x80, 0xFE, 0x00, 0x00, 0x00,
/* [ */ 0x00, 0x00, 0x1C, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1C, 0x00, 0x00, 0x00,
/* \ */ 0x00, 0x00, 0x00, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01, 0x00, 0x00, 0x00,
/* ] */ 0x00, 0x00, 0x38, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x38, 0x00, 0x00, 0x00,
/* ^ */ 0x10, 0x28, 0x44, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* _ */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00,
/* ` */ 0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* a */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x02, 0x7E, 0x82, 0x82, 0x7E, 0x00, 0x00, 0x00,
/* b */ 0x00, 0x00, 0x80, 0x80, 0x80, 0xF8, 0x84, 0x84, 0x84, 0x84, 0xF8, 0x00, 0x00, 0x00,
/* c */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x84, 0x80, 0x80, 0x84, 0x78, 0x00, 0x00, 0x00,

/* d */ 0x00, 0x00, 0x04, 0x04, 0x04, 0x7C, 0x84, 0x84, 0x84, 0x84, 0x7C, 0x00, 0x00, 0x00,

/* e */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x84, 0xFC, 0x80, 0x84, 0x78, 0x00, 0x00, 0x00,
/* f */ 0x00, 0x00, 0x38, 0x44, 0x40, 0x40, 0xE0, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00,
/* g */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x84, 0x84, 0x84, 0x7C, 0x04, 0x04, 0x78, 0x00,
/* h */ 0x00, 0x00, 0x80, 0x80, 0x80, 0xF8, 0x84, 0x84, 0x84, 0x84, 0x84, 0x00, 0x00, 0x00,
/* i */ 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00,
/* j */ 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x84, 0x78, 0x00,

/* k */ 0x00, 0x00, 0x80, 0x80, 0x80, 0x88, 0x90, 0xE0, 0x90, 0x88, 0x84, 0x00, 0x00, 0x00,
/* l */ 0x00, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00,
/* m */ 0x00, 0x00, 0x00, 0x00, 0x00, 0xEC, 0x92, 0x92, 0x92, 0x92, 0x82, 0x00, 0x00, 0x00,
/* n */ 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x84, 0x84, 0x84, 0x84, 0x84, 0x00, 0x00, 0x00,
/* o */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x84, 0x84, 0x84, 0x84, 0x78, 0x00, 0x00, 0x00,

/* p */ 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x84, 0x84, 0x84, 0x84, 0xF8, 0x80, 0x80, 0x00,

/* q */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x84, 0x84, 0x84, 0x84, 0x7C, 0x04, 0x04, 0x00,
/* r */ 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x84, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00,
/* s */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x80, 0x60, 0x18, 0x04, 0x78, 0x00, 0x00, 0x00,
/* t */ 0x00, 0x00, 0x00, 0x20, 0x20, 0xF8, 0x20, 0x20, 0x20, 0x20, 0x18, 0x00, 0x00, 0x00,
/* u */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x84, 0x84, 0x84, 0x84, 0x78, 0x00, 0x00, 0x00,

/* v */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10, 0x00, 0x00, 0x00,

/* w */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x92, 0xAA, 0xC6, 0x82, 0x00, 0x00, 0x00,

/* x */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x48, 0x30, 0x30, 0x48, 0x84, 0x00, 0x00, 0x00,

/* y */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x84, 0x84, 0x84, 0x84, 0x7C, 0x04, 0x04, 0x78, 0x00,

/* z */ 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x08, 0x10, 0x20, 0x40, 0xFC, 0x00, 0x00, 0x00,

/* { */ 0x00, 0x00, 0x0C, 0x10, 0x10, 0x10, 0x40, 0x10, 0x10, 0x10, 0x0C, 0x00, 0x00, 0x00,

/* | */ 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00,

/* } */ 0x00, 0x00, 0x60, 0x10, 0x10, 0x10, 0x04, 0x10, 0x10, 0x10, 0x60, 0x00, 0x00, 0x00,

/* */   0xFF, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0xFF,  
	 

 } ;




/* this next array is for 8 X 8 for CGA */
/**************************************************
 char char_table[1316] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 	// 
0x30, 0x78, 0x78, 0x30, 0x30, 0x00, 0x30, 0x00,
0x6C, 0x6C, 0x6C, 0x00, 0x00, 0x00, 0x00, 0x00,
0x6C, 0x6C, 0xFE, 0x6C, 0xFE, 0x6C, 0x6C, 0x00,
0x30, 0x7C, 0xC0, 0x78, 0x0C, 0xF8, 0x30, 0x00,
0x00, 0xC6, 0xCC, 0x18, 0x30, 0x66, 0xC6, 0x00,
0x38, 0x6C, 0x38, 0x76, 0xDC, 0xCC, 0x76, 0x00,
0x60, 0x60, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00,
0x18, 0x30, 0x60, 0x60, 0x60, 0x30, 0x18, 0x00,
0x60, 0x30, 0x18, 0x18, 0x18, 0x30, 0x60, 0x00,
0x00, 0x66, 0x3C, 0xFF, 0x3C, 0x66, 0x00, 0x00,
0x00, 0x30, 0x30, 0xFC, 0x30, 0x30, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x60,
0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00,
0x06, 0x0C, 0x18, 0x30, 0x60, 0xC0, 0x80, 0x00,
0x7C, 0xC6, 0xCE, 0xDE, 0xF6, 0xE6, 0x7C, 0x00,
0x30, 0x70, 0x30, 0x30, 0x30, 0x30, 0xFC, 0x00,
0x78, 0xCC, 0x0C, 0x38, 0x60, 0xCC, 0xFC, 0x00,
0x78, 0xCC, 0x0C, 0x38, 0x0C, 0xCC, 0x78, 0x00,
0x1C, 0x3C, 0x6C, 0xCC, 0xFE, 0x0C, 0x1E, 0x00,
0xFC, 0xC0, 0xF8, 0x0C, 0x0C, 0xCC, 0x78, 0x00,
0x38, 0x60, 0xC0, 0xF8, 0xCC, 0xCC, 0x78, 0x00,
0xFC, 0xCC, 0x0C, 0x18, 0x30, 0x30, 0x30, 0x00,
0x78, 0xCC, 0xCC, 0x78, 0xCC, 0xCC, 0x78, 0x00,
0x78, 0xCC, 0xCC, 0x7C, 0x0C, 0x18, 0x70, 0x00,
0x30, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00,
0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x60,
0x18, 0x30, 0x60, 0xC0, 0x60, 0x30, 0x18, 0x00,
0x00, 0x00, 0xFC, 0x00, 0x00, 0xFC, 0x00, 0x00,
0x60, 0x30, 0x18, 0x0C, 0x18, 0x30, 0x60, 0x00,
0x78, 0xCC, 0x0C, 0x18, 0x30, 0x00, 0x30, 0x00,
0x7C, 0xC6, 0xDE, 0xDE, 0xDE, 0xC0, 0x78, 0x00,
0x30, 0x78, 0xCC, 0xCC, 0xFC, 0xCC, 0xCC, 0x00,
0xFC, 0x66, 0x66, 0x7C, 0x66, 0x66, 0xFC, 0x00,
0x3C, 0x66, 0xC0, 0xC0, 0xC0, 0x66, 0x3C, 0x00,
0xF8, 0x6C, 0x66, 0x66, 0x66, 0x6C, 0xF8, 0x00,
0xFE, 0x62, 0x68, 0x78, 0x68, 0x62, 0xFE, 0x00,
0xFE, 0x62, 0x68, 0x78, 0x68, 0x60, 0xF0, 0x00,
0x3C, 0x66, 0xC0, 0xC0, 0xCE, 0x66, 0x3E, 0x00,
0xCC, 0xCC, 0xCC, 0xFC, 0xCC, 0xCC, 0xCC, 0x00,
0x78, 0x30, 0x30, 0x30, 0x30, 0x30, 0x78, 0x00,
0x1E, 0x0C, 0x0C, 0x0C, 0xCC, 0xCC, 0x78, 0x00,
0xE6, 0x66, 0x6C, 0x78, 0x6C, 0x66, 0xE6, 0x00,
0xF0, 0x60, 0x60, 0x60, 0x62, 0x66, 0xBE, 0x00,
0xC6, 0xEE, 0xFE, 0xFE, 0xD6, 0xC6, 0xC6, 0x00,
0xC6, 0xE6, 0xF6, 0xDE, 0xCE, 0xC6, 0xC6, 0x00,
0x38, 0x6C, 0xC6, 0xC6, 0xC6, 0x6C, 0x38, 0x00,
0xFC, 0x66, 0x66, 0x7C, 0x60, 0x60, 0xF0, 0x00,
0x78, 0xCC, 0xCC, 0xCC, 0xDC, 0x78, 0x1C, 0x00,
0xFC, 0x66, 0x66, 0x7C, 0x6C, 0x66, 0xE6, 0x00,
0x78, 0xCC, 0xE0, 0x70, 0x1C, 0xCC, 0x78, 0x00,
0xFC, 0xB4, 0x30, 0x30, 0x30, 0x30, 0x78, 0x00,
0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xFC, 0x00,
0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x78, 0x30, 0x00,
0xC6, 0xC6, 0xC6, 0xD6, 0xFE, 0xEE, 0xC6, 0x00,
0xC6, 0xC6, 0x6C, 0x38, 0x38, 0x6C, 0xC6, 0x00,
0xCC, 0xCC, 0xCC, 0x78, 0x30, 0x30, 0x78, 0x00,
0xFE, 0xC6, 0x8C, 0x18, 0x32, 0x66, 0xFE, 0x00,
0x78, 0x60, 0x60, 0x60, 0x60, 0x60, 0x78, 0x00,
0xC0, 0x60, 0x30, 0x18, 0x0C, 0x06, 0x02, 0x00,
0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x78, 0x00,
0x10, 0x38, 0x6C, 0xC6, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
0x30, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x78, 0x0C, 0x7C, 0xCC, 0x76, 0x00,
0xE0, 0x60, 0x60, 0x7C, 0x66, 0x66, 0xDC, 0x00,
0x00, 0x00, 0x78, 0xCC, 0xC0, 0xCC, 0x78, 0x00,
0x1C, 0x0C, 0x0C, 0x7C, 0xCC, 0xCC, 0x76, 0x00,
0x00, 0x00, 0x78, 0xCC, 0xFC, 0xC0, 0x78, 0x00,
0x38, 0x6C, 0x60, 0xF0, 0x60, 0x60, 0xF0, 0x00,
0x00, 0x00, 0x76, 0xCC, 0xCC, 0x7C, 0x0C, 0xF8,
0xE0, 0x60, 0x6C, 0x76, 0x66, 0x66, 0xE6, 0x00,
0x30, 0x00, 0x70, 0x30, 0x30, 0x30, 0x78, 0x00,
0x0C, 0x00, 0x0C, 0x0C, 0x0C, 0xCC, 0xCC, 0x78,
0xE0, 0x60, 0x66, 0x6C, 0x78, 0x6C, 0xE6, 0x00,
0x70, 0x30, 0x30, 0x30, 0x30, 0x30, 0x78, 0x00,
0x00, 0x00, 0xCC, 0xFE, 0xFE, 0xD6, 0xC6, 0x00,
0x00, 0x00, 0xF8, 0xCC, 0xCC, 0xCC, 0xCC, 0x00,
0x00, 0x00, 0x78, 0xCC, 0xCC, 0xCC, 0x78, 0x00,
0x00, 0x00, 0xDC, 0x66, 0x66, 0x7C, 0x60, 0xF0,
0x00, 0x00, 0x76, 0xCC, 0xCC, 0x7C, 0x0C, 0x1E,
0x00, 0x00, 0xDC, 0x76, 0x66, 0x60, 0xF0, 0x00,
0x00, 0x00, 0x7C, 0xC0, 0x78, 0x0C, 0xF8, 0x00,
0x10, 0x30, 0x7C, 0x30, 0x30, 0x34, 0x18, 0x00,
0x00, 0x00, 0xCC, 0xCC, 0xCC, 0xCC, 0x76, 0x00,
0x00, 0x00, 0xCC, 0xCC, 0xCC, 0x78, 0x30, 0x00,
0x00, 0x00, 0xC6, 0xD6, 0xFE, 0xFE, 0x6C, 0x00,
0x00, 0x00, 0xC6, 0x6C, 0x38, 0x6C, 0xC6, 0x00,
0x00, 0x00, 0xCC, 0xCC, 0xCC, 0x7C, 0x0C, 0xF8,
0x00, 0x00, 0xFC, 0x98, 0x30, 0x64, 0xFC, 0x00,
0x1C, 0x30, 0x30, 0xE0, 0x30, 0x30, 0x1C, 0x00,
0x15, 0x18, 0x15, 0x00, 0x15, 0x18, 0x15, 0x00,
0xE0, 0x30, 0x30, 0x1C, 0x30, 0x30, 0xE0, 0x00,
0x76, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x10, 0x38, 0x6C, 0xC6, 0xC6, 0xFE, 0x00,

};

*******************************/






