// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "test.h"
#include <ctl_api.h>
#include <targets/LH754xx.h>

#define EXTERNAL_INTERRUPT_5_INT 12


void
BoardInit(void)
{
  GPIO_PCDDR = 0xC0;
  GPIO_PCDR |= 0xC0;
}

unsigned long
TicksPerSecond(void)
{
  return 1000;
}

static CTL_ISR_FN_t userButtonISR;
static void
buttonISR(void)
{
  userButtonISR();
  RCPC_IntClear = 1 << 5;
}

void
SetButtonPressedISR(CTL_ISR_FN_t isr)
{
  userButtonISR = isr;


  /* Clear interrupt */
  RCPC_IntClear = 1 << 5;

  /* Configure Pin PD5/INT5/DACK to INT5 */
  IOCON_PD_MUX &= ~(3 << 7);
  IOCON_PD_MUX |= 1 << 7;

  /* Enable Pull-up resistor on INT5 */
  IOCON_PD_RES_MUX &= ~(3 << 10);
  IOCON_PD_RES_MUX |= 1 << 10;

  /* Falling edge trigger */
  RCPC_IntConfig &= ~3 << 10;
  RCPC_IntConfig |= 2 << 10;

  ctl_set_isr(EXTERNAL_INTERRUPT_5_INT, 1, CTL_ISR_TRIGGER_FIXED, buttonISR, 0);
  ctl_unmask_isr(EXTERNAL_INTERRUPT_5_INT);
}

void
SetLeds(unsigned v)
{
  if (v)
    GPIO_PCDR |= 0xC0;
  else
    GPIO_PCDR &= ~0xC0;
}
