// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

// Test message queues

#include <ctl_api.h>
#include "test.h"

CTL_TASK_t main_task, new_task;
CTL_MESSAGE_QUEUE_t mq;
#define QSIZE 10
void *queue[QSIZE];
unsigned int v=0;

#define CALLSTACKSIZE 16
#define STACKSIZE 64          
unsigned new_task_stack[STACKSIZE];

void 
new_task_code(void *p)
{  
  int v=0;
  while (1)
    {             
      ctl_message_queue_post(&mq, (void*)v, 0, 0);
      v++;
    }  
}

void
ctl_handle_error(CTL_ERROR_CODE_t e)
{
  while (1);
}

int main(void)
{
  int v;
  BoardInit();
  ctl_message_queue_init(&mq, queue, QSIZE);
  SetTimerISR(ctl_increment_tick_from_isr);
  ctl_task_init(&main_task, 0, "main");
  ctl_task_run(&new_task, 1, new_task_code, 0, "new_task", STACKSIZE, new_task_stack, CALLSTACKSIZE);  
  while (1)
    {          
      v = (int)ctl_message_queue_receive(&mq, 0, 0);
    }
  return 0;
}
