// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "test.h"
#include <ctl_api.h>
#include <targets/LPC210x.h>

#define TIMER0_INT 4

unsigned long idleCount;

static CTL_ISR_FN_t userTimerISR;

static void
timerISR(void)
{
  userTimerISR();
  /* Clear the timer 0 interrupt */
  T0IR = 0xFF;
}

void
SetTimerISR(CTL_ISR_FN_t isr)
{
  T0TCR = 0; /* Reset timer 0 */
  T0PR = 2; /* Set the timer 0 prescale counter */
  T0MR0 = 1000; /* Set timer 0 match register */
  T0MCR = 3; /* Generate interrupt and reset counter on match */
  T0TCR = 1;   /* Start timer 0 */
  userTimerISR = isr;
  ctl_set_isr(TIMER0_INT, 0, CTL_ISR_TRIGGER_FIXED, timerISR, 0);
  ctl_unmask_isr(TIMER0_INT);
}

void
Idle()
{
  ++idleCount;
}
