// Copyright (c) 2001-2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                 IAR LPC210x KickStart Secondary JTAG Example
//
// Description
// -----------
// This example demonstrates enabling the secondary JTAG pins.
//
// To run this example:
//
// 1. Set the "secondary_jtag" project as the active project.
// 2. Set the active build configuration to "ARM Flash Debug".
// 3. Make sure JP6 on the kickstart board is set to JTAG1, if it isn't
//    set it and reset the board.
// 4. Build and download this program.
// 5. Set JP6 on the kickstart board to JTAG2 and reset the board.
// 6. Re-connect the target (Target | Reconnect).
// 7. Select another project, you should now be able to download and debug
//    this project using the secondary JTAG pins. The secondary JTAG pins will
//    remain enabled until the target is reset.
//
////////////////////////////////////////////////////////////////////////////////

  .section .vectors, "ax"
  .code 32
  .align 0

/*****************************************************************************
 * Exception Vectors                                                         *
 *****************************************************************************/
_vectors:
  ldr pc, [pc, #reset_handler_address - . - 8]  /* reset */
  ldr pc, [pc, #undef_handler_address - . - 8]  /* undefined instruction */
  ldr pc, [pc, #swi_handler_address - . - 8]    /* swi handler */
  ldr pc, [pc, #pabort_handler_address - . - 8] /* abort prefetch */
  ldr pc, [pc, #dabort_handler_address - . - 8] /* abort data */
#ifdef VECTORED_IRQ_INTERRUPTS
  .word 0xB9205F84                              /* boot loader checksum */
  ldr pc, [pc, #-0xFF0]                         /* irq handler */
#else
  .word 0xB8A06F60                              /* boot loader checksum */
  ldr pc, [pc, #irq_handler_address - . - 8]    /* irq handler */
#endif
  ldr pc, [pc, #fiq_handler_address - . - 8]    /* fiq handler */

reset_handler_address:
  .word reset_handler
undef_handler_address:
  .word undef_handler
swi_handler_address:
  .word swi_handler
pabort_handler_address:
  .word pabort_handler
dabort_handler_address:
  .word dabort_handler
irq_handler_address:
  .word irq_handler
fiq_handler_address:
  .word fiq_handler

  .section .init, "ax"
  .code 32
  .align 0

/******************************************************************************
 *                                                                            *
 * Default exception handlers                                                 *
 *                                                                            *
 ******************************************************************************/

#define PINSEL1 0xE002C004

reset_handler:
  /* Set P0.27-P0.31 alternative function 1 (secondary JTAG pins). */
  ldr r0, =PINSEL1
  ldr r1, =0x55400000
  str r1, [r0]

  /* Loop forever */
1:
  b 1b

/******************************************************************************
 *                                                                            *
 * Default exception handlers                                                 *
 * These are declared weak symbols so they can be redefined in user code.     * 
 *                                                                            *
 ******************************************************************************/

undef_handler:
  b undef_handler
  
swi_handler:
  b swi_handler
  
pabort_handler:
  b pabort_handler
  
dabort_handler:
  b dabort_handler
  
irq_handler:
  b irq_handler
  
fiq_handler:
  b fiq_handler

  .weak undef_handler, swi_handler, pabort_handler, dabort_handler, irq_handler, fiq_handler
                                                    

                  
