// Copyright (c) 2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "test.h"
#include <ctl_api.h>
#include <targets/LH79524.h>

#define TIMER0_INT 4

#define HCLK_FREQUENCY 50803200

unsigned long idleCount;

static CTL_ISR_FN_t userTimerISR;

static void
timerISR(void)
{
  userTimerISR();
  /* Clear the timer 0 interrupt */
  TIMER_STATUS0 = 0x4;
}

void
SetTimerISR(CTL_ISR_FN_t isr)
{
 /* Setup comparator to generate interrupts at 1KHz */
  TIMER_T0CMP1 = HCLK_FREQUENCY / 2 / 1000;
  /* Free running timer */
  TIMER_CMP_CAP_CTRL = 0x4000;
  /* Interrupt on compare 1 */
  TIMER_INTEN0 = 0x4;
  /* Enable interrupts, timer clock frequency = HCLK / 2 */
  TIMER_CTRL0 = 0x2;
  userTimerISR = isr;
  ctl_set_isr(TIMER0_INT, 0, CTL_ISR_TRIGGER_FIXED, timerISR, 0);
  ctl_unmask_isr(TIMER0_INT);
}

void
Idle()
{
  ++idleCount;
}
