// Copyright (c) 2001-2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//     Logic Product Development SDKLH79520-10 Interrupt Example
//
// Description
// -----------
// This example demonstrates setting up interrupt handlers.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/LH79520.h>

#define BUTTON_INT 0

#define EXTENDED_GPIO_REG *((volatile unsigned char *)0x55600000)

static int isrCount = 0;

static void buttonISR(void) __attribute__ ((interrupt ("IRQ")));

static void
buttonISR(void)
{
  if (++isrCount % 2)
    EXTENDED_GPIO_REG |= 1;
  else
    EXTENDED_GPIO_REG &= ~1;
  /* Clear the interrupt */
  IntClear = 1 << BUTTON_INT;
  /* Update VIC priorities */
  VectorAddr = 0;
}

int
main(void)
{
  /* Initialise LEDs */
  EXTENDED_GPIO_REG &= ~3;

  /* Write "ldr pc, [pc, #-0xFF0]" instruction to IRQ exception vector */
  *(volatile unsigned long *)(0x00000018) = 0xE51FFFF0; 

  /* Button interrupt is an IRQ interrupt */
  IntSelect &= ~(1 << BUTTON_INT);
  /* Enable button interrupt */
  IntEnable = 1 << BUTTON_INT;
  /* Use slot 0 for button interrupt */
  VectCntl0 = 0x20 | BUTTON_INT;
  /* Set the address of ISR for slot 0 */
  VectAddr0 = (unsigned int)buttonISR;

  /* Trigger interrupt on rising edge */
  IntConfig |= 3;

  /* Enable Interrupts */
  __ARMLIB_enableIRQ();
  
  while (1);

  return 0; 
}
