// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
////////////////////////////////////////////////////////////////////////////////
//
//                    Atmel EB55 Interrupt Example
//
// Description
// -----------
// This example demonstrates a simple interrupt handler. When running, pressing
// the SW1-SW4 buttons causes the irq_handler to execute which toggles
// the LEDs.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/AT91M55800A.h>

// Interrupt definitions
#define AIC_SMR(n) (*(&AIC_SMR0 + n))
#define AIC_SVR(n) (*(&AIC_SVR0 + n))

#define AIC_SRCTYPE_INT_LEVEL_SENSITIVE 0x00    /* Level Sensitive */
#define AIC_SRCTYPE_INT_EDGE_TRIGGERED  0x20    /* Edge Triggered */
#define AIC_SRCTYPE_EXT_LOW_LEVEL       0x00    /* Low Level */
#define AIC_SRCTYPE_EXT_NEGATIVE_EDGE   0x20    /* Negative Edge */
#define AIC_SRCTYPE_EXT_HIGH_LEVEL      0x40    /* High Level */
#define AIC_SRCTYPE_EXT_POSITIVE_EDGE   0x60    /* Positive Edge */

#define SW1 (1 << 20)
#define SW2 (1 << 9)
#define SW3 (1 << 17)
#define SW4 (1 << 19)

#define PIOBIRQ_INT 14
#define IRQ0_INT 29

void piob_irq_handler(void) __attribute__ ((interrupt ("IRQ")));
void
piob_irq_handler(void)
{
  unsigned long isr = PIOB_ISR;
  unsigned long pdsr = PIOB_PDSR;
  if (isr & SW1)
    {
      if (pdsr & SW1)
        PIOB_CODR = 0x00000300;
      else
        PIOB_SODR = 0x00000300;
    }
  if (isr & SW3)
    {
      if (pdsr & SW3)
        PIOB_CODR = 0x00003000;
      else
        PIOB_SODR = 0x00003000;
    }
  if (isr & SW4)
    {
      if (pdsr & SW4)
        PIOB_CODR = 0x0000C000;
      else
        PIOB_SODR = 0x0000C000;
    }
  AIC_EOICR = 0;
}

void irq0_handler(void) __attribute__ ((interrupt ("IRQ")));
void
irq0_handler(void)
{
  static int toggle;
  toggle ^= 1;
  if (toggle)
    PIOB_CODR = 0x00000C00;
  else
    PIOB_SODR = 0x0000C00;
  AIC_EOICR = 0;
}

int
main(void)
{
  // Put LDR PC, [PC, #-0xF20] instruction into IRQ vector in order to use 
  // hardware interrupt vectoring.
  *(volatile unsigned int *)0x00000018 = 0xE51FFF20;

  // Enable PIO clocks.
  APMC_PCER = 0x6000;

   // Set up PIO interrupt
  AIC_IDCR = 1 << PIOBIRQ_INT;
  AIC_SVR(PIOBIRQ_INT) = (unsigned)piob_irq_handler;
  AIC_SMR(PIOBIRQ_INT) = AIC_SRCTYPE_INT_EDGE_TRIGGERED;
  AIC_ICCR = 1 << PIOBIRQ_INT;
  AIC_IECR = 1 << PIOBIRQ_INT;
  PIOB_ODR = SW1 | SW3 | SW4;
  PIOB_PER = SW1 | SW3 | SW4;
  PIOB_MDDR = ~(SW1 | SW3 | SW4);
  PIOB_MDER = SW1 | SW3 | SW4;
  PIOB_IER = SW1 | SW3 | SW4;

  // Set up IRQ0 interrupt
  AIC_IDCR = 1 << IRQ0_INT;
  AIC_SVR(IRQ0_INT) = (unsigned)irq0_handler;
  AIC_SMR(IRQ0_INT) = AIC_SRCTYPE_EXT_NEGATIVE_EDGE;
  AIC_ICCR = 1 << IRQ0_INT;
  AIC_IECR = 1 << IRQ0_INT;
  PIOA_PDR = SW2;

  // Set up LEDs
  PIOB_PER = 0x0000FF00;
  PIOB_OER = 0x0000FF00;
  PIOB_SODR = 0x0000FF00;

   __ARMLIB_enableIRQ();

  while(1);

}
