// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                      Atmel AT91SAM7S-EK LED Example
//
// Description
// -----------
// This example demonstrates writing to the PIO ports and also how to place
// functions into the .fast section.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/AT91SAM7.h>

static void
ledInit()
{
  PIOA_PER = 0x0000000F;
  PIOA_OER = 0x0000000F;
}

static void
cycle(int n)
{
  int m = 0;
  for (; n; m++, n--)
    {
      PIOA_CODR = 0xF;
      delay(m);
      PIOA_SODR = 0xF;
      delay(n);
    }

  for (; m; m--, n++)
    {
      PIOA_CODR = 0xF;
      delay(m);
      PIOA_SODR = 0xF;
      delay(n);
    }
}

int
main(void)
{
  ledInit();

  while (1)
    {
      cycle(800);
      cycle(1200);
      delay(300000);
    }

  return 0;
}


