// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
// test0
// A CTL application that creates two tasks that wait on a timer whilst the main task loops.

#include <string.h>
#include <ctl_api.h>
#include "test.h"

CTL_TASK_t mainTask,other1Task,other2Task;
int othercount;

#define CALLSTACKSIZE 16 // this is only required for AVR builds
#define STACKSIZE 64
unsigned other1Stack[1+STACKSIZE+1], other2Stack[1+STACKSIZE+1]; // allocate 1 word before and after to aid debugging stack space problems

void 
other(void *p)
{
  while (1)
    {
      othercount++;
      ctl_timeout_wait(ctl_get_current_time()+1000);      
    }  
}

void
ctl_handle_error(CTL_ERROR_CODE_t e)
{
  while (1);
}

int
main(void)
{  
  BoardInit();  
  // initialise the stack space to a known value
  // and put marker values before and after the stack to aid debugging
  memset(other1Stack, 0xcd, sizeof(other1Stack));
  memset(other2Stack, 0xcd, sizeof(other2Stack));
  other1Stack[0]=other1Stack[1+STACKSIZE]=other2Stack[0]=other2Stack[1+STACKSIZE]=0xfacefeed;
  // turn main into a task
  ctl_task_init(&mainTask, 0, "main");
  // start the timer running
  SetTimerISR(ctl_increment_tick_from_isr);
  // let the tasks go - add 1 to the stack to keep the marker value
  ctl_task_run(&other1Task, 1, other, 0, "other1", STACKSIZE, other1Stack+1, CALLSTACKSIZE);
  ctl_task_run(&other2Task, 1, other, 0, "other2", STACKSIZE, other2Stack+1, CALLSTACKSIZE);
  // main now becomes the idle task - this could go into low-power mode if supported by the processor
  while (1)
    Idle();
}
