/*****************************************************************************
 * Copyright (c) 2004 Rowley Associates Limited.                             *
 *                                                                           *
 * This file may be distributed under the terms of the License Agreement     *
 * provided with this software.                                              *
 *                                                                           *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE   *
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. *
 *****************************************************************************/

  .section .vectors, "ax"
  .code 32
  .align 0
  .global reset_handler

/*****************************************************************************
 * Exception Vectors                                                         *
 *****************************************************************************/
_vectors:
  ldr pc, [pc, #reset_handler_address - . - 8] /* reset */
  ldr pc, [pc, #undef_handler_address - . - 8] /* undefined instruction */
  ldr pc, [pc, #swi_handler_address - . - 8] /* swi handler */
  ldr pc, [pc, #pabort_handler_address - . - 8] /* abort prefetch */
  ldr pc, [pc, #dabort_handler_address - . - 8] /* abort data */
  nop
  ldr pc, [pc, #irq_handler_address - . - 8]
  ldr pc, [pc, #fiq_handler_address - . - 8]

reset_handler_address:
  .word reset_handler
undef_handler_address:
  .word undef_handler
swi_handler_address:
  .word swi_handler
pabort_handler_address:
  .word pabort_handler
dabort_handler_address:
  .word dabort_handler
irq_handler_address:
  .word irq_handler
fiq_handler_address:
  .word fiq_handler

  .section .init, "ax"
  .code 32
  .align 0

/******************************************************************************
 *                                                                            *
 * Default exception handlers                                                 *
 *                                                                            *
 ******************************************************************************/
reset_handler:
  /* Configure the processor */
  adr r0, board_configuration
  bl configure_registers32
  /* Jump to the default C runtime startup code. */
  b _start

board_configuration:
  .word 0x40E00018, 0xFFFFFFFF /* GPSR0 */
  .word 0x40E0000C, 0xCD82A858 /* GPDR0 */
  .word 0x40E00010, 0xFCFFAB80 /* GPDR1 */
  .word 0x40E00014, 0x0001FFFF /* GPDR2 */
  .word 0x40E00054, 0x80000000 /* GAFR0_L */
  .word 0x40E00058, 0xA5254010 /* GAFR0_U */
  .word 0x40E0005C, 0x599A9550 /* GAFR1_L */
  .word 0x40E00060, 0xAAA5AAAA /* GAFR1_U */
  .word 0x40E00064, 0xAAAAAAAA /* GAFR2_L */
  .word 0x40E00068, 0x00000002 /* GAFR2_U */
  .word 0x48000008, 0x2EF925D8 /* MSC0 */  
  .word 0x00000000, 0x00000000 /* Terminator */

/* configure_registers32 - Configure a list of 32 bit registers.
 *
 * On entry r0 points to the start of a list of {address, value} pairs which 
 * are terminated by an entry with a zero address.
 */
configure_registers32:
  ldmia r0!, {r1 ,r2}
  cmp r1, #0
  moveq pc, lr
  str r2, [r1]
  b configure_registers32

/******************************************************************************
 *                                                                            *
 * Default exception handlers                                                 *
 * These are declared weak symbols so they can be redefined in user code.     * 
 *                                                                            *
 ******************************************************************************/

undef_handler:
  b undef_handler
  
swi_handler:
  b swi_handler
  
pabort_handler:
  b pabort_handler
  
dabort_handler:
  b dabort_handler
  
irq_handler:
  b irq_handler
  
fiq_handler:
  b fiq_handler

  .weak undef_handler, swi_handler, pabort_handler, dabort_handler, irq_handler, fiq_handler

