/*****************************************************************************
 * Copyright (c) 2001, 2002 Rowley Associates Limited.                       *
 *                                                                           *
 * This file may be distributed under the terms of the License Agreement     *
 * provided with this software.                                              *
 *                                                                           *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE   *
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. *
 *****************************************************************************/

/* 
 * Enable vectored IRQ interrupts. If defined, the PC register will be loaded
 * with the contents of the VICVectAddr register on an IRQ exception.
 *
 * #define VECTORED_IRQ_INTERRUPTS
 * 
 */

/* 
 * Connect PLL as processor clock source. If undefined, the oscillator clock
 * will be used.
 *
 * #define USE_PLL
 * 
 */

/* 
 * Enable copying and re-mapping of interrupt vectors from User FLASH to 
 * SRAM. If undefined, interrupt vectors will be mapped in User FLASH.
 *
 * #define SRAM_EXCEPTIONS
 * 
 */

#define PLLCON  0x0
#define PLLCFG  0x4
#define PLLSTAT 0x8
#define PLLFEED 0xC

  .section .vectors, "ax"
  .code 32
  .align 0

/*****************************************************************************
 * Exception Vectors                                                         *
 *****************************************************************************/
_vectors:
  ldr pc, [pc, #reset_handler_address - . - 8]  /* reset */
  ldr pc, [pc, #undef_handler_address - . - 8]  /* undefined instruction */
  ldr pc, [pc, #swi_handler_address - . - 8]    /* swi handler */
  ldr pc, [pc, #pabort_handler_address - . - 8] /* abort prefetch */
  ldr pc, [pc, #dabort_handler_address - . - 8] /* abort data */
#ifdef VECTORED_IRQ_INTERRUPTS
  .word 0xB9205F84                              /* boot loader checksum */
  ldr pc, [pc, #-0xFF0]                         /* irq handler */
#else
  .word 0xB8A06F60                              /* boot loader checksum */
  ldr pc, [pc, #irq_handler_address - . - 8]    /* irq handler */
#endif
  ldr pc, [pc, #fiq_handler_address - . - 8]    /* fiq handler */

reset_handler_address:
  .word reset_handler
undef_handler_address:
  .word undef_handler
swi_handler_address:
  .word swi_handler
pabort_handler_address:
  .word pabort_handler
dabort_handler_address:
  .word dabort_handler
irq_handler_address:
  .word irq_handler
fiq_handler_address:
  .word fiq_handler

  .section .init, "ax"
  .code 32
  .align 0

/******************************************************************************
 *                                                                            *
 * Default exception handlers                                                 *
 *                                                                            *
 ******************************************************************************/

reset_handler:
#ifdef USE_PLL
  /* Use PLL as processor clock source */
  mov r0, #0xe0000000
  add r0, r0, #0x1fc000
  add r0, r0, #0x80
  /* Configure PLL Multiplier/Divider */
  mov r1, #0x24 /* multipler = 5, divider = 2 */
  str r1, [r0, #PLLCFG]
  /* Enable PLL */
  mov r1, #0x1
  str r1, [r0, #PLLCON]
  mov r1, #0xAA
  str r1, [r0, #PLLFEED]
  mov r1, #0x55
  str r1, [r0, #PLLFEED]
  /* Wait for PLL to lock */
pll_lock_loop:
  ldr r1, [r0, #PLLSTAT]
  tst r1, #0x400
  beq pll_lock_loop
  /* PLL Locked, connect PLL as clock source */
  mov r1, #0x3
  str r1, [r0, #PLLCON]
  mov r1, #0xAA
  str r1, [r0, #PLLFEED]
  mov r1, #0x55
  str r1, [r0, #PLLFEED]
#endif

#ifdef SRAM_EXCEPTIONS
  /* Copy exception vectors into SRAM */
  mov r8, #0x40000000
  ldr r9, =_vectors
  ldmia r9!, {r0-r7}
  stmia r8!, {r0-r7}
  ldmia r9!, {r0-r6}
  stmia r8!, {r0-r6}

  /* Re-map interrupt vectors from SRAM */
  ldr r0, MEMMAP
  mov r1, #2 /* User RAM Mode. Interrupt vectors are re-mapped from SRAM */
  str r1, [r0]
#endif /* SRAM_EXCEPTIONS */
  
  b _start

#ifdef SRAM_EXCEPTIONS
MEMMAP:
  .word 0xE01FC040
#endif

/******************************************************************************
 *                                                                            *
 * Default exception handlers                                                 *
 * These are declared weak symbols so they can be redefined in user code.     * 
 *                                                                            *
 ******************************************************************************/

undef_handler:
  b undef_handler
  
swi_handler:
  b swi_handler
  
pabort_handler:
  b pabort_handler
  
dabort_handler:
  b dabort_handler
  
irq_handler:
  b irq_handler
  
fiq_handler:
  b fiq_handler

  .weak undef_handler, swi_handler, pabort_handler, dabort_handler, irq_handler, fiq_handler
                                                    

                  
