/*****************************************************************************
 * Copyright (c) 2001, 2002 Rowley Associates Limited.                       *
 *                                                                           *
 * This file may be distributed under the terms of the License Agreement     *
 * provided with this software.                                              *
 *                                                                           *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE   *
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. *
 *****************************************************************************/

  .section .vectors, "ax"
  .code 32
  .align 0

  .equ GPCTL, 0xB7000000
  
/*****************************************************************************
 * Exception Vectors                                                         *
 *****************************************************************************/
_vectors:
  ldr pc, [pc, #reset_handler_address - . - 8]
  ldr pc, [pc, #undef_handler_address - . - 8]
  ldr pc, [pc, #swi_handler_address - . - 8]
  ldr pc, [pc, #pabort_handler_address - . - 8]
  ldr pc, [pc, #dabort_handler_address - . - 8]
  nop
  ldr pc, [pc, #irq_handler_address - . - 8]
  ldr pc, [pc, #fiq_handler_address - . - 8]

reset_handler_address:
  .word reset_handler
undef_handler_address:
  .word undef_handler
swi_handler_address:
  .word swi_handler
pabort_handler_address:
  .word pabort_handler
dabort_handler_address:
  .word dabort_handler
irq_handler_address:
  .word irq_handler
fiq_handler_address:
  .word fiq_handler

  .section .init, "ax"
  .code 32
  .align 0

/******************************************************************************
 *                                                                            *
 * Default exception handlers                                                 *
 *                                                                            *
 ******************************************************************************/
reset_handler:
  /* Configure external memory */
  ldr r9, =XMEM_config
  ldmia r9!, {r0-r4, r8}
  stmia r8!, {r0-r4}

  /* Configure DRAM */
  ldr r9, =DRAM_config
  ldmia r9!, {r0-r8}
  stmia r8!, {r0-r7}

  /* Enable external bus function (second function of PIOA[14:10]) */
  mov r0, #GPCTL
  ldrh r1, [r0]
  orr r1, r1, #0x4
  strh r1, [r0]
  
#ifdef __FLASH_BUILD

  /* Copy exception vectors into SRAM */
  mov r8, #0xD0000000
  ldr r9, =_vectors
  ldmia r9!, {r0-r7}
  stmia r8!, {r0-r7}
  ldmia r9!, {r0-r6}
  stmia r8!, {r0-r6}     

  /* Remap External SRAM to 0x00000000 */
  mov r8, #0xB8000000
  orr r8, r8, #0x10
  mov r9, #0x0000003C
  str r9, [r8, #0]
  mov r9, #0x00000008
  str r9, [r8, #0]
  
#endif

  /* Jump to the default C runtime startup code. */
  b _start

XMEM_config:
  .word 0x00000068 /* BWC */
  .word 0x00000003 /* ROMAC */
  .word 0x00000001 /* RAMAC */
  .word 0x00000007 /* IO0AC */
  .word 0x00000007 /* IO0AC */
  .word 0x78100000 /* &BWC */

DRAM_config:
  .word 0x00000000 /* DBWC */
  .word 0x00000000 /* DRMC */
  .word 0x00000000 /* DRPC */
  .word 0x00000000 /* SDMD */
  .word 0x00000000 /* DCMD */
  .word 0x00000000 /* RFSH0 */
  .word 0x00000000 /* RDWC */
  .word 0x00000000 /* RFSH1 */
  .word 0x78180000 /* &DBWC */

/******************************************************************************
 *                                                                            *
 * Default exception handlers                                                 *
 * These are declared weak symbols so they can be redefined in user code.     * 
 *                                                                            *
 ******************************************************************************/

undef_handler:
  b undef_handler
  
swi_handler:
  b swi_handler
  
pabort_handler:
  b pabort_handler
  
dabort_handler:
  b dabort_handler
  
irq_handler:
  b irq_handler
  
fiq_handler:
  b fiq_handler

  .weak undef_handler, swi_handler, pabort_handler, dabort_handler, irq_handler, fiq_handler

