/*****************************************************************************
 * Copyright (c) 2001, 2002 Rowley Associates Limited.                       *
 *                                                                           *
 * This file may be distributed under the terms of the License Agreement     *
 * provided with this software.                                              *
 *                                                                           *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE   *
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. *
 *****************************************************************************/

  .global _start
  .extern C_Entry
  .global stack_start
  .global stack_end

  .text
  .code 32

/*****************************************************************************
 * Function    : init_sys_clk                                                *
 * Description : Setup the system clocks                                     *
 *****************************************************************************/
init_sys_clk:
  /* r1 = 0xfffe2000 */
  mov r1, #0x88000000
  mov r1, r1, asr #0xe 
  mov r0, #1
  str r0, [r1, #0x18] /* SysClkPrescale: divider = 2 */
  mov pc, lr

/*****************************************************************************
 * Function    : _start                                                      *
 * Description : Minimal startup code for C system.                          *
 *****************************************************************************/
_start:                         
  bl init_sys_clk

  /* r1 = 0xFFFF1000 */
  mov r1, #0x88000000
  mov r1, r1, asr #0xf 

  /* BCR0 */
  mov r0, #0x18000000
  add r0, r0, #0x2D00
  add r0, r0, #0x0003
  str r0, [r1, #0x0] 

  /* BCR2 */
  mov r0, #0x10000000
  add r0, r0, #0x0C00
  add r0, r0, #0x0021
  str r0, [r1, #0x8] 

  /* r1 = 0xFFFE5000 */
  mov r1, #0x94000000
  mov r1, r1, asr #0xe 

  /* EBI_MUX */
  mov r0, #0x7F00
  add r0, r0, #0xFF
  str r0, [r1, #0]
  
  /* Setup stack */ 
  add sp, pc, #1024 
  
  /* Jump to main entry point */
  bl C_Entry

  /* Return from main, loop forever. */
loop:
  b loop
                            
stack_start:
  .fill 1024
stack_end:
                  
