function Reset()
{
  TargetInterface.trst();
  TargetInterface.beginDebugAccess();
  /* Perform a soft reset of the target */
  TargetInterface.setICEBreakerBreakpoint(0, 0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x100, 0xF7);
  TargetInterface.pokeWord(0xFFFE200C, 0xDEAD);
  TargetInterface.endDebugAccess(true);
  TargetInterface.waitForDebugState(1000);
  TargetInterface.trst();
  TargetInterface.setICEBreakerBreakpoint(0, 0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x0, 0xF7);
}

function SRAMReset()
{
  Reset();
  TargetInterface.pokeWord(0xFFFE2008, 0x00000002); // Map Internal SRAM to 0x00000000
  TargetInterface.pokeWord(0xFFFF1000, 0x10002D03); // SBC0
  TargetInterface.pokeWord(0xFFFE5000, 0x00007FFF); // EBI_MUX
}

function FLASHReset()
{
  Reset();
  TargetInterface.pokeWord(0xFFFE2008, 0x00000000); // Map external memory to 0x00000000
  TargetInterface.pokeWord(0xFFFF1000, 0x10002D03); // SBC0
  TargetInterface.pokeWord(0xFFFE5000, 0x00007FFF); // EBI_MUX
}


