/*****************************************************************************
 * Copyright (c) 2001, 2002 Rowley Associates Limited.                       *
 *                                                                           *
 * This file may be distributed under the terms of the License Agreement     *
 * provided with this software.                                              *
 *                                                                           *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE   *
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. *
 *****************************************************************************/
  .section .vectors, "ax"
  .code 32
  .align 0

  .global _start
  .extern C_Entry
  .global stack_start
  .global stack_end

/*****************************************************************************
 * Minimal set of exception handlers which will be in place once memory      *
 * has been remapped.                                                        *
 *****************************************************************************/
reset_handler:
  b configure_memory
undef_handler:
  b undef_handler
swi_handler:  
  b swi_handler
pabort_handler:
  b pabort_handler
dabort_handler:
  b dabort_handler
  .word 0
irq_handler:
  b irq_handler
fiq_handler:
  b fiq_handler

  .text
  .code 32

/*****************************************************************************
 * Configure the memory the same as the final running system so that all the *
 * load addresses are correct.                                               *
 *****************************************************************************/
configure_memory:
  sub r10, pc, #(+.-system_configuration+8)
  ldr r12, =_start
  ldmia r10!, {r0-r9, r11}
  stmia r11!, {r0-r9}
      
/*****************************************************************************
 * Jump to _start which will be at the correct address when the program      *
 * counter gets there.                                                       *
 *****************************************************************************/
  mov pc, r12
                  
/******************************************************************************
 * System configuration registers for the following memory layout:            *
 *                                                                            *
 *     ------------------                                                     *
 *    |      FLASH       | 0x01000000 - 0x011FFFFF                            *
 *    |------------------|                                                    *
 *    |      SRAM        | 0x00000000 - 0x0003FFFF                            *
 *     ------------------                                                     *
 *                                                                            *
 ******************************************************************************/
system_configuration:
.word 0x01002535 // EBI_CSR0
.word 0x02002121 // EBI_CSR1
.word 0x20000000 // EBI_CSR2
.word 0x30000000 // EBI_CSR3
.word 0x40000000 // EBI_CSR4
.word 0x50000000 // EBI_CSR5
.word 0x60000000 // EBI_CSR6
.word 0x70000000 // EBI_CSR7
.word 0x00000001 // EBI_RCR (remap command)
.word 0x00000006 // EBI_MCR (6 memory regions, standard read)
.word 0xFFE00000 // EBI Base Address

/*****************************************************************************
 * Function    : _start                                                      *
 * Description : Minimal startup code for C system.                          *
 *****************************************************************************/
_start:

  /* Setup stack */ 
  add sp, pc, #800
  
  /* Jump to main entry point */
  bl C_Entry

  /* Return from main, loop forever. */
loop:
  b loop
                          
stack_start:
  .fill 800
stack_end:
                  

