/******************************************************************************
  Target Script for ATMEL AT91SAM7.

  Copyright (c) 2004 Rowley Associates Limited.

  This file may be distributed under the terms of the License Agreement
  provided with this software.

  THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
  WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ******************************************************************************/

function Reset()
{
  /* Reset and stop target */
  TargetInterface.pokeWord(0xFFFFFD00, 0xA500000D); // RSTC_CR
  TargetInterface.waitForDebugState(1000);
  /* Configure Clock */
  TargetInterface.pokeWord(0xFFFFFC20, 0x00000601); // CKGR_MOR
  TargetInterface.delay(10);
  TargetInterface.pokeWord(0xFFFFFC2C, 0x00191C05); // CKGR_PLLR
  TargetInterface.delay(10);
  TargetInterface.pokeWord(0xFFFFFC30, 0x00000007); // CKGR_MCKR
}

function RAMReset()
{
  Reset();
  /* Remap SRAM to 0x00000000 */
  TargetInterface.pokeWord(0xFFFFFF00, 1); // MC_RCR 
}

function FLASHReset()
{
  Reset();
}

