// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                Revely RMS101 SBC Timer Interrupt Example
//
// Description
// -----------
// This example demonstrates setting up interrupt handlers and timers.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/LH79520.h>

#define TIMER0_INT 17
#define TIMER1_INT 18

static int timer0Count, timer1Count;

static void
ledInit()
{
  GPIOPFDDR = 2;
  GPIOPFDR |= 2;
}

static void
ledOn()
{
  GPIOPFDR &= ~2;
}

static void
ledOff()
{
  GPIOPFDR |= 2;
}

static void timer0ISR(void) __attribute__ ((interrupt ("IRQ")));

static void
timer0ISR(void)
{
  if (++timer0Count % 2)
    ledOn();
  else
    ledOff();
  /* Clear the timer 0 interrupt */
  TIMER0Clear = 0;
  /* Update VIC priorities */
  VectorAddr = 0;
}

static void timer1ISR(void) __attribute__ ((interrupt ("IRQ")));

static
void
timer1ISR(void)
{
  ++timer1Count;
  /* Clear the timer 1 interrupt */
  TIMER1Clear = 0;
  /* Update VIC priorities */
  VectorAddr = 0;
}

int
main(void)
{
  ledInit();

  /* Write "ldr pc, [pc, #-0xFF0]" instruction to IRQ exception vector */
  *(volatile unsigned long *)(0x00000018) = 0xE51FFFF0; 

  /* Timer 0 interrupt is an IRQ interrupt */
  IntSelect &= ~(1 << TIMER0_INT);
  /* Enable timer 0 interrupt */
  IntEnable = 1 << TIMER0_INT;
  /* Use slot 0 for timer 0 interrupt */
  VectCntl0 = 0x20 | TIMER0_INT;
  /* Set the address of ISR for slot 0 */
  VectAddr0 = (unsigned int)timer0ISR;

  /* Timer 1 interrupt is an IRQ interrupt */
  IntSelect &= ~(1 << TIMER1_INT);
  /* Enable timer 1 interrupt */
  IntEnable = 1 << TIMER1_INT;
  /* Use slot 1 for timer 1 interrupt */
  VectCntl1 = 0x20 | TIMER1_INT;
  /* Set the address of ISR for slot 1 */
  VectAddr1 = (unsigned int)timer1ISR;

  /* Enable clock to timer 0 and 1 */
  PeriphClkCtrl &= ~0x10;

  /* Start timer 0, set clock division to 256 */
  TIMER0Control = 0x88;

  /* Start timer 1, set clock division to 256 */
  TIMER1Control = 0x88;

  /* Enable Interrupts */
  __ARMLIB_enableIRQ();
  
  while (timer0Count < 5 && timer1Count < 5);

  return 0; 
}
