/*===============================< graphics.h >==============================*/
#ifndef _GRAPHICS
#define _GRAPHICS

/*==============================< Defines >==================================*/
// 16 color basic palette
#define BLACK 			0
#define WHITE 			1
#define DARKGREY 		2
#define GREY			3
#define RED				4
#define BROWN			5
#define YELLOW			6
#define DARKYELLOW	7
#define GREEN			8
#define DARKGREEN		9
#define CYAN			10
#define DARKCYAN		11
#define BLUE			12
#define DARKBLUE		13
#define PURPLE			14
#define DARKPURPLE	15
#define BACKGROUND	17

// 16 color basic palette (abrev names)
#define BK 	0
#define WT 	1
#define DGY 2
#define GY	3
#define RD	4
#define BR	5
#define YW	6
#define DY	7
#define GN	8
#define DGN	9
#define CY	10
#define DCY	11
#define BL	12
#define DBL	13
#define PR	14
#define DPR	15
#define BG	17

// Font Styles
#define THIN 		0
#define BOLD		1

/*========================< Function Prototypes >============================*/

/*-----------------------------< GraphInit >---------------------------------*/
// To initialize graphics and video, all the application code needs to do is
// call this function with appropriate parameters.  GraphInit will make the
// necessary low level calls.
// Parameters	:	bRes		Resolution mode (0..2)
//						bOut		Output mode (RGB, NTSC)
// Returns 	:		nothing
void GraphInit(BYTE bRes, BYTE bOut);

/*-----------------------------< GraphDraw >---------------------------------*/
// Draws a single pixel on the screen in the requested color.
// 0,0 is top left corner.  Assumes 8 bit color.
// Parameters	:	x			X coordinate 
//						y			Y coordinate
//						c			Color (0..255)
// Returns 	:		nothing
void GraphDraw(HALF x, HALF y, BYTE c);

/*----------------------------< GraphTextXY >--------------------------------*/
// Displays a text string in the requested font style and color.
// 0,0 is top left corner.  Assumes 8 bit color.
// Parameters	:	sStr		Pointer to string to display
//						x			X coordinate (top left corner of text) 
//						y			Y coordinate (top left corner of text)
//						c			Color (0..255)
//						bStyle	Font (0..1)
// Returns	:		nothing
void GraphTextXY(PCHAR sStr, HALF x, HALF y, BYTE c, BYTE bStyle);

/*-----------------------------< GraphLine >---------------------------------*/
// Draws a line on the screen between two sets of coordinates.
// 0,0 is top left corner.  Assumes 8 bit color.
// Parameters	:	x1			Starting X coordinate  
//						y1			Starting Y coordinate 
//						x2			Ending X coordinate  
//						y2			Ending Y coordinate 
//						c			Color (0..255)
// Returns	:		nothing
void GraphLine(HALF x1, HALF y1, HALF x2, HALF y2, BYTE bColor);

/*--------------------------< GraphRectangle >-------------------------------*/
// Draws either an open or filled rectangle in the requested color
// 0,0 is top left corner.  Assumes 8 bit color.
// Parameters	:	x1			Starting X coordinate  
//						y1			Starting Y coordinate 
//						x2			Ending X coordinate  
//						y2			Ending Y coordinate 
//						bColor	Color (0..255)
//						bFill		0=False, 1=True
// Returns	:		nothing
void GraphRectangle(HALF x1, HALF y1, HALF x2, HALF y2, BYTE bColor, BYTE bFill);

/*-------------------------< GraphSetBackground >----------------------------*/
// Selects one of the first 16 color palette entries to be the new background
// color.
// Parameters	:	bColor	Color from 0..15			
// Returns	:		nothing
void GraphSetBackground(BYTE bColor);

/*--------------------------< GraphSetPalette >------------------------------*/
// Initializes the 8-bit palette with 16 basic colors and a background color.
// Parameters	:	none
// Returns :		nothing
void GraphSetPalette(void);

/*--------------------------< GraphGetPalette >------------------------------*/
// Use to convert 16 and 24 bit RGB colors into an equivalent color from our
// 216 color palette.
// Parameters	:	wColor	Color value to convert 
//						bBits 	Number of bits in input data (16, 24 or 32)
//	Returns :		WORD 		Index into color palette (40..255)
WORD GraphGetPalette(WORD wColor, BYTE bBits);

/*----------------------------< GraphClear >---------------------------------*/
// Clears the display by setting all pixels to the background color (17)
// Parameters	:	none
// Returns :		nothing
void GraphClear(void);

/*--------------------------< GraphSetDrawScreen >---------------------------*/
// Selects the current draw to screen.  All Graph draw functions are now
// performed on the selected screen buffer.
// Parameters	:	bScr		Screen to draw to (0..1)
//	Returns :		nothing
void GraphSetDrawScreen(BYTE bScr);

/*--------------------------< GraphSetViewScreen >---------------------------*/
// Selects the current view screen.  The contents of the selected screen 
// buffer will be displayed on the monitor.
// Parameters	:	bScr		Screen to display (0..1)
//	Returns :		nothing
void GraphSetDrawScreen(BYTE bScr);

/*--------------------------< GraphDisplayBitMap >---------------------------*/
// Displays a full-color bitmap on the screen.  Use the DOS application 
// BMP2C.EXE (available on the Sharp KEV79520 CD image) to convert a BMP file
// to C source.  Must be used in 640x480 15 bit color mode. See show.c for
// usage example.
// Parameters	:	pData		Pointer to BMP image
//						wXSize	X size of image in pixels
//						wYSize	Y size of image in pixels
//						bScale	1=1:1  2=2:1
// Returns :		nothing
void GraphDisplayBitMap(PHALF pData, WORD wXsize, WORD wYsize, BYTE bScale);

/*---------------------------< GraphGetResMode >-----------------------------*/
// Returns the current Resolution Mode setting.
// Parameters	:	none
// Returns	:		Resolution Mode setting.
BYTE GraphGetResMode(void);

/*---------------------------< GraphGetOutMode >-----------------------------*/
// Returns the current Output Mode setting.
// Parameters	:	none
// Returns	:		Output Mode setting (NTSC or RGB) 
BYTE GraphGetOutMode(void);

/*----------------------------< GraphGetPixel >------------------------------*/
// Returns the color of a specified pixel
// Parameters 	:	wX 	X coordinate of pixel
//						wY		Y coordinate of pixel
// Returns	:		BYTE 	Pixel color (8 bit color)
BYTE GraphGetPixel(WORD wX, WORD wY);

WORD GraphDrawSprite(WORD wX, WORD wY, PBYTE pDat);
WORD GraphMoveSprite(WORD wH, CHAR cDX, CHAR cDY);
void GraphKillSprite(WORD wH);

#endif


// end of graphics.h
