/*==============================< card.h >==================================*/
// Header file for Multimedia card functions

// MMC Commands
#define GO_IDLE_STATE		0 
#define SEND_OP_COND			1
#define SEND_CSD				9
#define SEND_CID				10
#define STOP_TRANSMISSION	12
#define SEND_STATUS			13
#define SET_BLOCKLEN			16
#define READ_SINGLE_BLOCK	17
#define READ_MULTIPLE_BLOCK	18
#define SET_BLOCK_COUNT		23
#define WRITE_BLOCK			24
#define WRITE_MULTIPLE_BLOCK	25
#define PROGRAM_CSD			27
#define SET_WRITE_PORT		28
#define CLR_WRITE_PORT		29
#define SEND_WRITE_PROT		30
#define TAG_ERASE_START		35
#define TAG_ERASE_END		36
#define ERASE					38
#define LOCKUNLOCK			42
#define READ_OCR 				58
#define CRC_ON_OFF			59

// Other defines
#define BLOCKSIZE			512


/*==========================< Function Prototypes >==========================*/

/*------------------------------< CardSlotInit >-----------------------------*/
// Initializes the SPI port ready for card communications.  Must be called
// first.
// Parameters	:	none
// Returns :		nothing
void CardSlotInit(void);

/*-------------------------------< CardDetect >------------------------------*/
// Checks to see if a valid card is present. Also puts card in SPI mode.
// Call after CardSlotInit()
// Parameters	:	none
// Returns:			TRUE if card is detected
BYTE CardDetect(void);

/*--------------------------------< CardInit >-------------------------------*/
// Runs the cards initialization process.  Call after a valid CardDetect().
// Parameters	:	none
// Returns:			TRUE if card is initialized successfully.
BYTE CardInit(void);

/*------------------------------< CardReadBlock >----------------------------*/
// Reads 512 bytes (1 block) from the multimedia card.  
// Parameters	:	wAddr		Address to read from, must be a 512 byte boundary
//						pDat		Pointer to buffer to store bytes
// Returns	:		BYTE		True if successful
BYTE CardReadBlock(WORD wAddr, PBYTE pDat);

/*------------------------------< CardWriteBlock >---------------------------*/
// Writes 512 bytes (1 block) to the multimedia card.  
// Parameters	:	wAddr		Address to write to, must be a 512 byte boundary
//						pDat		Pointer to bufffer to write
// Returns	:		BYTE		True if successful
BYTE CardWriteBlock(WORD wAddr, PBYTE pDat);

// end of card.h
