// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                Keil MCB2130 Specific ctl example code
//
// Description
// -----------
// This module contains the MCB2130 specific source code for running the CTL
// examples.
// NOTE: For the button press examples to run properly, J7 should be set.
//
////////////////////////////////////////////////////////////////////////////////

#include "test.h"
#include <ctl_api.h>
#include <targets/LPC210x.h>

#define EINT1_INT 15

void
BoardInit(void)
{
  IO1DIR |= 0xFF << 16;
  IO1SET = 0xFF << 16;
}

unsigned long
TicksPerSecond(void)
{
  return 1000;
}

static CTL_ISR_FN_t userButtonISR;
static void
buttonISR(void)
{
  userButtonISR();
  EXTINT = 2;
}

void
SetButtonPressedISR(CTL_ISR_FN_t isr)
{
  userButtonISR = isr;
  // P0.14 to alternate function 2 (EINT1)
  PINSEL0 |= 2 << 28;
  ctl_set_isr(EINT1_INT, 1, CTL_ISR_TRIGGER_FIXED, buttonISR, 0);
  ctl_unmask_isr(EINT1_INT);
}

void
SetLeds(unsigned v)
{
  IO1SET = (v & 0xFF) << 16;
  IO1CLR = (~v & 0xFF) << 16;
}
