// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//           Logic Product Development SDKLH75401-10 LED Example
//
// Description
// -----------
// This example demonstrates writing to the GPIO ports and also how to place
// functions into the .fast section.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/LH754xx.h>

extern void delay(volatile unsigned int d);

#define GPIO_REG *((volatile unsigned char *)0x4C580000)

static void
cycle(int n)
{
  int m = 0;
  for (; n; m++, n--)
    {
      GPIO_REG &= ~1;
      delay(m);
      GPIO_REG |= 1;
      delay(n);
    }

  for (; m; m--, n++)
    {
      GPIO_REG &= ~1;
      delay(m);
      GPIO_REG |= 1;
      delay(n);
    }
}

int
main(void)
{
  int i, j;
  while (1)
    {
      cycle(300);
      cycle(500);
      delay(200000);
    }
  return 0;
}
