// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "test.h"
#include <ctl_api.h>
#include <targets/ADuC7020.h>

#define IRQ0_INT 15

void
BoardInit(void)
{
  GP4CON &= ~(3 << 16); /* Set P4.2 to GPIO function */
  GP4DAT |= 1 << (2 + 24); /* Set P4.2 to output */
}

unsigned long
TicksPerSecond(void)
{
  return 1000;
}

static CTL_ISR_FN_t userButtonISR;
static void
buttonISR(void)
{
  userButtonISR();
}

void
SetButtonPressedISR(CTL_ISR_FN_t isr)
{
  userButtonISR = isr;
  ctl_set_isr(IRQ0_INT, 1, CTL_ISR_TRIGGER_FIXED, buttonISR, 0);
  ctl_unmask_isr(IRQ0_INT);
}

void
SetLeds(unsigned v)
{
  if (v)
    GP4CLR = 1 << (2 + 16);
  else
    GP4SET = 1 << (2 + 16);
}
