// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "test.h"
#include <ctl_api.h>
#include <targets/ADuC7020.h>

#define TIMER0_INT 2

#define CORE_CLOCK_FREQUENCY 45088000
#define TIMER_CORE_CLOCK_DIVIDER 16
#define TIMER_FREQUENCY 1000
#define TIMER_RECHARGE (CORE_CLOCK_FREQUENCY / TIMER_CORE_CLOCK_DIVIDER / TIMER_FREQUENCY)

unsigned long idleCount;

static CTL_ISR_FN_t userTimerISR;

static void
timerISR(void)
{
  /* Restart the timer */
  T0LD = TIMER_RECHARGE;
  /* Call timer ISR */
  userTimerISR();
  /* Clear the timer 0 interrupt */
  T0CLRI = 0;
}

void
SetTimerISR(CTL_ISR_FN_t isr)
{
  T0LD = TIMER_RECHARGE;
  T0CON = 0xC4; /* Timer 0 enable, periodic, core clock / 16 */
  userTimerISR = isr;
  ctl_set_isr(TIMER0_INT, 0, CTL_ISR_TRIGGER_FIXED, timerISR, 0);
  ctl_unmask_isr(TIMER0_INT);
}

void
Idle()
{
  ++idleCount;
}
