// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                      Aeroflex AX07CF192 LED Example
//
// Description
// -----------
// This example demonstrates writing to the GPIO port.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/AX07CF192.h>

static void
ledInit()
{
  /* Set P75 to output */
  P7DDR &= ~(1 << 5);
}

static void
ledOn(void)
{
  P7DR &= ~(1 << 5);
}

static void
ledOff(void)
{
  P7DR |= 1 << 5;
}

void
delay(int d)
{     
  for(; d; --d);
}
 
int
main(void)
{
  BCR0 = 3;
  FMWR = 4;
  ledInit();
  while (1)
    {
      ledOn();
      delay(100000);
      ledOff();
      delay(100000);
    }
  return 0;
}


