// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
// test3
// A CTL application that creates a task which is scheduled when a button is pressed or a timer expires
// This illustrates the use of an event set between ISR's and a task.
// This also shows that the builtin timer support of CTL is optional.

#include <string.h>
#include <ctl_api.h>
#include "test.h"

#define CALLSTACKSIZE 16 // this is only required for AVR builds
#define STACKSIZE 64
CTL_TASK_t mainTask, otherTask;
unsigned otherStack[1+STACKSIZE+1];
unsigned e1=0;
unsigned count = 0;
unsigned count2 = 0;

#define BUTTON_EVENT (1<<0)
#define TIMER_EVENT (1<<1)

void 
buttonPressedISR(void)
{
  count++;
  ctl_events_set_clear(&e1, BUTTON_EVENT, 0);
}

void
timerISR(void)
{
  count2++;
  ctl_events_set_clear(&e1, TIMER_EVENT, 0);
}

void 
other(void *p)
{
  while (1)
    {
      unsigned w=ctl_events_wait(CTL_EVENT_WAIT_ANY_EVENTS, &e1, BUTTON_EVENT|TIMER_EVENT, 0, 0);
      if (w & BUTTON_EVENT)
      {
        ctl_events_set_clear(&e1, 0, BUTTON_EVENT);
        SetLeds(0);
      }
      else if (w & TIMER_EVENT)
      {
        ctl_events_set_clear(&e1, 0, TIMER_EVENT);
        if ((count2 % 5000)==0)      
          SetLeds(0xffffffff);          
      }
      else
        ; // error case
    }
}

void
ctl_handle_error(CTL_ERROR_CODE_t e)
{
  while (1);
}

int main(void)
{
  unsigned int v=0;
  BoardInit();
  ctl_task_init(&mainTask, 0, "main");  
  memset(otherStack, 0xcd, sizeof(otherStack));
  otherStack[0]=otherStack[1+STACKSIZE]=0xfacefeed;
  ctl_task_run(&otherTask, 1, other, 0, "other", STACKSIZE, otherStack+1, CALLSTACKSIZE);
  SetTimerISR(timerISR);
  SetButtonPressedISR(buttonPressedISR);
  while (1)
    Idle();  
}
