function LPC210X_Reset()
{
  TargetInterface.setNSRST(0);
  TargetInterface.setNSRST(1);
  TargetInterface.delay(100);
  TargetInterface.trst();
  TargetInterface.setICEBreakerBreakpoint(0, 0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x100, 0xF7);
  TargetInterface.waitForDebugState(1000);
  TargetInterface.getICEBreakerRegister(5); /* Clear out Debug Comms Data */
  TargetInterface.pokeWord(0xE0000000, 0); /* Reset Watchdog */
  TargetInterface.pokeWord(0xE0028008, 0); /* Reset IODIR */
  TargetInterface.pokeWord(0xE002C000, 0); /* Reset PINSEL0 */
  TargetInterface.pokeWord(0xE01FC000, 0); /* Reset MAMCR */
  TargetInterface.pokeWord(0xE01FC080, 0);  /* Reset PLL */
  TargetInterface.pokeWord(0xE01FC08C, 0xAA);  /* Feed PLL */
  TargetInterface.pokeWord(0xE01FC08C, 0x55);  /* Feed PLL */
  TargetInterface.pokeWord(0xFFFFF014, 0xFFFFFFFF); /* Disable all interrupts */
  TargetInterface.setICEBreakerBreakpoint(0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000, 0x00);
}

function LPC210X_ResetWithSRAMVectorsAtZero()
{
  LPC210X_Reset();
  TargetInterface.pokeWord(0xE01FC040, 2);
}

function LPC210X_ResetWithBootLoaderFLASHVectorsAtZero()
{
  LPC210X_Reset();
  TargetInterface.pokeWord(0xE01FC040, 0);
}
