function Reset()
{
  TargetInterface.setICEBreakerBreakpoint(0, 0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x100, 0xF7);
  TargetInterface.runTestIdle();
  TargetInterface.setNSRST(0);
  TargetInterface.setNSRST(1);
  TargetInterface.waitForDebugState(1000);
  TargetInterface.trst();
}

function ResetWithRamAtZero()
{
  Reset();

  // Setup External SRAM
  TargetInterface.pokeWord(0xFFFFA108, 0x9090); // BCR2
  TargetInterface.pokeWord(0xFFFFA048, 0x7C04); // SDR2
  TargetInterface.pokeWord(0xFFFFA008, 0x00000000); // START2
  TargetInterface.pokeWord(0xFFFFA028, 0x00080000); // STOP2
}

function ResetWithFlashAtZero()
{
  Reset();
  // Enable Cache SRAM mode, so that there is enough room for FLASH loader.
  TargetInterface.pokeWord(0xFFFFA404, 0x3) // LSCR (Enable internal SRAM @ 0x60000000)
  TargetInterface.pokeWord(0xFFFFA400, 0x2) // CCR  (Enable SRAM mode)
  // Reset Bank 1 and 2
  TargetInterface.pokeWord(0xFFFFA004, 0); // START1
  TargetInterface.pokeWord(0xFFFFA024, 0); // STOP1
  TargetInterface.pokeWord(0xFFFFA044, 0); // SDR1
  TargetInterface.pokeWord(0xFFFFA104, 0); // BCR1
  TargetInterface.pokeWord(0xFFFFA008, 0); // START2
  TargetInterface.pokeWord(0xFFFFA028, 0); // STOP2
  TargetInterface.pokeWord(0xFFFFA048, 0); // SDR2
  TargetInterface.pokeWord(0xFFFFA108, 0); // BCR2
}
