// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                      ST ST2051 UART Example
//
// Description
// -----------
// This example demonstrates configuring and writing to a UART. It also 
// demonstrates how to get printf output over the UART by implementing 
// __putchar.
//
// To see output:
//   - Connect serial cable from UART 0 on the target board to your host 
//     computer.
//   - Open CrossStudio's "Terminal Emulator Window". Configure it to 4800 baud, 
//     8 data bits, no parity, 2 stop bits. Click "Connect" to start the
//     terminal emulator window.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/ST2051.h>

#define PROCESSOR_CLOCK_FREQUENCY 32000000

#include <stdio.h>

void
UARTInitialize(unsigned long baudrate)
{
  UART0_ASCControl = 0;
  UART0_ASCBaudRate = PROCESSOR_CLOCK_FREQUENCY / (16 * baudrate);
  UART0_ASCControl = 0x89;
}

void
UARTWriteChar(char ch)
{
  while (!(UART0_ASCStatus & 0x2));
  UART0_ASCTxBuffer = (char)ch;  
}

void __putchar(int ch)
{
  if (ch == '\n')
    UARTWriteChar('\r');
  UARTWriteChar(ch);
}

int
main(void)
{
  int i;

  UARTInitialize(4800);

  for (i = 0;; ++i)
    printf("Hello World (%d) !\n", i);

  return 0;
}
