/*=================================< flash.h >================================*/
/* Flash Part         :LH28F320BF.h
* Data wide           :x16
* Block size          :8kb,64k
* boot type           :Bottom
* revision original   :2001/03/29
**********************/
#ifndef		_F320BF_H
#define		_F320BF_H

/**********************
* defines
**********************/
#define FLASH_BASEADD                      0x40000000
#define FLASH_BLOCKS								38 	// Number of Flash Blocks

#define MAX_MULTI_WRITE_NUM					16		// may need to change this
#define MASK_MULTI_WRITE						16		// may need to change this

/**********************
* DEVICE ID 
**********************/
#define ID_MAKER_CODE                      0x00B0
#define ID_DEVICE_CODE                     0x00B5

/**********************
* address offset
**********************/
#define ID_DEVICE_OFFSET                   1
#define ID_BLOCK_OFFSET                    2
#define ID_PCR_OFFSET                      6
#define MASK_BOOT_BLOCK_ADD                0xFFFFF000
#define MASK_MAIN_BLOCK_ADD		           0xFFFF8000
#define BLOCK_STRUCTURE_BORDER_ADD	       0x00008000
#define COUNTER_MASK_BOOT_BLOCK        	   0x00000FFF
#define COUNTER_MASK_MAIN_BLOCK		       0x00007FFF
#define PART0_START_OFFSET                 0x00000000
#define PART1_START_OFFSET                 0x00080000
#define PART2_START_OFFSET                 0x00100000
#define PART3_START_OFFSET                 0x00180000

/**********************
* bit mask
**********************/
#define BIT_0                              0x0001
#define BIT_1                              0x0002
#define BIT_2                              0x0004
#define BIT_3                              0x0008
#define BIT_4                              0x0010
#define BIT_5                              0x0020
#define BIT_6                              0x0040
#define BIT_7                              0x0080
#define HIGH                               1
#define LOW                                0
#define HIGH_BYTE                          0xff00
#define LOW_BYTE                           0x00ff

/**********************
* flash commands
**********************/
#define CMD_READ_ARRAY                     0xFFFF
#define CMD_DATA_WRITE                     0x4040
#define CMD_BLOCK_ERASE                    0x2020
#define CMD_FULL_CHIP_ERASE                0x3030
#define CMD_SUSPEND                        0xB0B0
#define CMD_READ_STATUS                    0x7070
#define CMD_CLEAR_STATUS                   0x5050
#define CMD_CONFIRM                        0xD0D0
#define CMD_RESUME                         0xD0D0
#define CMD_READ_ID_CODE                   0x9090
#define CMD_BLOCK_LOCK			           0x6060
#define CMD_SET_LOCKBIT			           0x0101
#define CMD_RESET_LOCKBIT		           0xD0D0
#define CMD_SET_LOCKDOWNBIT		           0x2F2F
#define CMD_SET_PCR                        0x6060
#define CMD_PCR_CONFIRM                    0x0404
#define CMD_OTP_WRITE			           0xC0C0
#define CMD_MULTI_DATA_WRITE               0xE8E8

/**********************
* CSR flags
**********************/
#define CSR_WSM_STATUS_READY               0x0080
#define CSR_ERASE_SUSPEND                  0x0040
#define CSR_ERASE_ERROR                    0x0020
#define CSR_WRITE_ERROR                    0x0010
#define CSR_LOW_VPP                        0x0008
#define CSR_WRITE_SUSPEND                  0x0004
#define CSR_DEVICE_PROTECT                 0x0002

/**********************
* XSR flags
**********************/
#define XSR_MULTI_WRITE_READY              0x0080

/**********************
* Error codes
**********************/
#define ERR_NO_ERROR                       0
#define ERR_LOW_VPP                        1
#define ERR_BLOCK_LOCKED                   2
#define ERR_COMMAND_SEQ_ERROR              3
#define ERR_WP_LOW                         4
#define ERR_WRITE                          5
#define ERR_ERASE                          6
#define ERR_OPERATION                      7
#define ERR_WRITE_ERASING_BLOCK            8

/**********************
* block structure
**********************/
#define BOOT_BLOCK_SIZE                    0x00002000		// in bytes
#define MAIN_BLOCK_SIZE                    0x00010000		// in bytes


/*==========================< Unit Prototypes >==============================*/

/*---------------------------< FlashChipErase >------------------------------*/
// Erases entire chip (back to 0xffff).  Note that this function can take
// awhile (30-60sec or more).  Older devices take even longer.  
// Refer to Flash datasheet.
// Parameters	:	none
// Returns :		nothing
void FlashChipErase(void);

/*---------------------------< FlashBlockErase >-----------------------------*/
// Erases 1 or more blocks.  Depending on number of blocks and their status
// this command can take awhile also.
// Parameters	:	bFirstBlock		Block number to start erasing at (0..70)
//						bLastBlock		Block number to stop erasing at (0..70)
// Returns :		nothing
void FlashBlockErase(BYTE bFirstBlock, BYTE bLastBlock);

/*----------------------------< FlashWriteHalf >-----------------------------*/
// Writes a HALF (16 bit value) to the specified address.
// Parameters	:	wAddr		Address to write to (0x40000000-0x403ffffe)
//						hData		16 bit data value to write
//	Returns			nothing
void FlashWriteHalf(WORD wAddr, HALF hData);

/*-----------------------------< FlashLockAll >------------------------------*/
// Locks all flash memory blocks (prevents erasure and writing).
// Parameters	:	none
//	Returns		:  nothing
void FlashLockAll(void);

/*----------------------------< FlashUnlockAll >-----------------------------*/
// Unlocks all flash memory blocks (enables erasure and writing).
// Parameters	:	none
//	Returns		:  nothing
void FlashUnlockAll(void);


#endif 

// end of flash.h
