// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include <ctl_api.h>
#include "test.h"

void start_timer(void);
long ticks_per_sec(void);

CTL_TASK_t main_task, timer_task, blink_task;
CTL_EVENT_SET_t e1;

#define STACKSIZE 64          
unsigned timer_stack[STACKSIZE];
unsigned blink_stack[STACKSIZE];

void 
timer(void *p)
{  
  unsigned int v=0;
  while (1)
    {      
      ctl_task_wait(CTL_STATE_TIMER_WAIT, ctl_current_time + TicksPerSecond(), 0, 0);  
      ctl_set_clear_events(&e1, 1, 0);
      v++;
    }  
}

void 
blink(void *p)
{  
  unsigned int v=0;
  unsigned led = 0xFFFFFFFF;
  while (1)
    { 
      ctl_task_wait(CTL_STATE_EVENT_WAIT, 0, &e1, 1);     
      ctl_set_clear_events(&e1, 0, 1);  
      SetLeds(led);
      led ^= 0xFFFFFFFF;
      v++;   
    }
}

void
ctl_handle_error(CTL_ERROR_CODE_t e)
{
  while (1);
}

int main(void)
{
  BoardInit();
  SetTimerISR(ctl_increment_tick_from_isr);
  ctl_task_init(&main_task, 0, "main");
  ctl_task_run(&timer_task, 1, timer, 0, "timer", sizeof(timer_stack)/sizeof(unsigned), timer_stack);
  ctl_task_run(&blink_task, 1, blink, 0, "blink", sizeof(blink_stack)/sizeof(unsigned), blink_stack);
  while (1)
    Idle();
  return 0;
}
