// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include <ctl_api.h>
#include <string.h>
#include "test.h"

CTL_TASK_t mainTask,other1Task,other2Task;
int othercount;

#define STACKSIZE 64
unsigned other1Stack[1+STACKSIZE+1], other2Stack[1+STACKSIZE+1];
unsigned e1=1;

void 
other(void *p)
{
  unsigned v=0;
  while (1)
    {
      v++;
      ctl_task_wait(CTL_STATE_EVENT_WAIT | CTL_STATE_EVENT_AUTO_CLEAR, 0, &e1, 1);  
      ctl_task_wait(CTL_STATE_TIMER_WAIT, ctl_current_time+1000, 0, 0);
      ctl_set_clear_events(&e1, 1, 0);   
    }  
}

void
ctl_handle_error(CTL_ERROR_CODE_t e)
{
  while (1);
}

int
main(void)
{
  int i;
  BoardInit();
  ctl_task_init(&mainTask, 0, "main"); 
  SetTimerISR(ctl_increment_tick_from_isr);
  memset(other1Stack, 0xcd, sizeof(other1Stack));
  memset(other2Stack, 0xcd, sizeof(other2Stack));
  other1Stack[0]=other1Stack[1+STACKSIZE]=other2Stack[0]=other2Stack[1+STACKSIZE]=0xfacefeed;
  ctl_task_run(&other1Task, 1, other, 0, "other1", STACKSIZE, other1Stack+1);
  ctl_task_run(&other2Task, 1, other, 0, "other2", STACKSIZE, other2Stack+1);
  while (1)
    Idle();
}
