// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                       OKI ML674000 SIO Example
//
// Description
// -----------
// This example demonstrates configuring and writing to the SIO port. It also 
// demonstrates how to get printf output over the SIO port by implementing 
// __putchar.
//
// To see output:
//   - Connect serial cable from SIO on the ML674000 board to your host
//     computer.
//   - Open CrossStudio's "Terminal Emulator Window". Configure it to 9600 baud, 
//     8 data bits, no parity, 2 stop bits. Click "Connect" to start the
//     terminal emulator window.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/ML674000.h>

#define PROCESSOR_CLOCK_FREQUENCY 33000000L

void
SIOInitialize(unsigned baudrate)
{
  SIOBCN = 0x0000; /* Stop baud rate timer */
  SIOSTA = 0x0037; /* Reset the status register */
  SIOTCN = 0x0000; /* Reset the test register */
  SIOBT = 256 - (PROCESSOR_CLOCK_FREQUENCY / (baudrate * 16)); /* Set counter reload value */
  SIOCON = 0; /* 8 bits, no parity, 2 stop bits */
  CGBCNT0 = 0x003c; /* Enable writing CGBCNT0 register */
  CGBCNT0 = 0x0000; /* 1-minute circumference */
  GPCTL |= 0x2; /* Select PIOA[9:8] to secondry function (STXD, SRXD) */
  SIOBCN = 0x10; /* Start baud rate timer */
}

void
SIOWriteChar(unsigned char c)
{
  SIOSTA = 0x20;
  SIOBUF = c;
  while ((SIOSTA & 0x20) == 0);
}

void 
__putchar(int ch)
{
  if (ch == '\n')
    SIOWriteChar('\r');
  SIOWriteChar(ch);
}

int
main(void)
{
  int i;
  SIOInitialize(9600);

  for (i = 0;; ++i)
    printf("Hello World (%d)\n", i);
        

  return 0;
}

