// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                      MPE ARM7DK LED Example
//
// Description
// -----------
// This example demonstrates writing to the programmable peripheral interface.
//
////////////////////////////////////////////////////////////////////////////////

#define PPI_PA (*(volatile unsigned long *)0xFFFF1C00)
#define PPI_PB (*(volatile unsigned long *)0xFFFF1C04)
#define PPI_PC (*(volatile unsigned long *)0xFFFF1C08)
#define PPI_CTLR (*(volatile unsigned long *)0xFFFF1C0C)

static void
ledInit()
{
  PPI_CTLR = 0x80;
}

static void
ledOn(void)
{
  PPI_PC &= ~0x8;
}

static void
ledOff(void)
{
  PPI_PC |= 0x8;
}

void
delay(int d)
{     
  for(; d; --d);
}
 
int
main(void)
{
  ledInit();
  while (1)
    {
      ledOn();
      delay(100000);
      ledOff();
      delay(100000);
    }
  return 0;
}


