// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                    Analog ADuC7020 - UART Example
//
// Description
// -----------
// This example demonstrates configuring and writing to a UART. It also 
// demonstrates how to get printf output over the UART by implementing 
// __putchar.
//
// To see output:
//   - Connect serial cable from the UART 0 connector on your target board to 
//     your host computer.
//   - Open CrossStudio's "Terminal Emulator Window". Configure it to 4800 baud, 
//     8 data bits, no parity, 1 stop bits. Click "Connect" to start the
//     terminal emulator window.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/ADuC7020.h>

#define PROCESSOR_CLOCK_FREQUENCY 45088000

static void
UARTInitialize(unsigned int baud)
{
  unsigned int divisor = PROCESSOR_CLOCK_FREQUENCY / (32 * baud);
  GP1CON = 0x11;

  COMCON0 = 0x80;
  COMDIV0 = (unsigned char)divisor;
  COMDIV1 = (unsigned char)(divisor >> 8);
  COMCON0 = 0x07;

}

static void
UARTWriteChar(unsigned char ch)
{

  while ((COMSTA0 & 0x20) == 0);
  COMTX = ch;
}

static unsigned char
UARTReadChar(void)
{
  while ((COMSTA0 & 0x01) == 0);
  return COMRX;
}

static int
UARTReadAvailable(void)
{
  return COMSTA0 & 0x01;
}

void 
__putchar(int ch)
{
  if (ch == '\n')
    UARTWriteChar('\r');
  UARTWriteChar(ch);
}

int
main(void)
{
  int i;
  UARTInitialize(4800);
  for (i = 0; ; ++i)
    {
      printf("Hello World (%d)\n", i);
      if (UARTReadAvailable())
        { 
          char ch = UARTReadChar();
          if (ch == 'q' || ch == 'Q')
            break;
          printf("Key \'%c\' pressed\n", ch);
        }
    }
  printf("Quit\n");
  return 0; 
}

