// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                    Analog ADuC7020 Interrupt Example
//
// Description
// -----------
// This example demonstrates setting up an interrupt handler.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/ADuC7020.h>

#define IRQ0_INT 15

static int count;

static void
ledInit()
{
  GP4CON &= ~(3 << 16); /* Set P4.2 to GPIO function */
  GP4DAT |= 1 << (2 + 24); /* Set P4.2 to output */
}

static void
ledOn()
{
  GP4CLR = 1 << (2 + 16);
}

static void
ledOff()
{
  GP4SET = 1 << (2 + 16);
}

void irq_handler(void) __attribute__ ((interrupt ("IRQ")));

void
irq_handler(void)
{
  unsigned int status = IRQSTA;
  if (status & (1 << IRQ0_INT))
    {
      if (count++ % 2)
        ledOn();
      else
        ledOff();
    }
}

int
main(void)
{
  ledInit();

  IRQEN |= 1 << IRQ0_INT; /* IRQ0 generates IRQ interrupts */

  /* Enable Interrupts */
  __ARMLIB_enableIRQ();
  
  return 0; 
}
