// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                         Atmel EB40A LED Example
//
// Description
// -----------
// This example demonstrates writing to the PIO ports and also how to place
// functions into the .fast section.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/AT91x408xx.h>

#define LED_3           1<<3
#define LED_4           1<<4
#define LED_5           1<<5
#define LED_6           1<<6
#define LED_16          1<<16
#define LED_17          1<<17
#define LED_18          1<<18
#define LED_19          1<<19
#define LEDS (LED_3 | LED_4 | LED_5 | LED_6 | LED_16 | LED_17 | LED_18 | LED_19)

void ledInit()
{
  PIO_PER = LEDS;
  PIO_OER = LEDS;
}

void ledOff(int led)
{
  PIO_SODR = led;
}

void ledOn(int led)
{
  PIO_CODR = led;
}

#define NUM_LEDS 8

int leds[] = { LED_16, LED_17, LED_18, LED_19, LED_3, LED_4, LED_5, LED_6};

// Put delay routine in the .fast section so that both FLASH and RAM
// configurations delay for the same time.
int delay(int i) __attribute__((section(".fast")));

int delay(int i)
{
  for (; i; --i);
  return 0;
}

int
main(void)
{
  int i, j;
  ledInit();
  while (1)
    {
      for (i = 0; i < NUM_LEDS; ++i)
        {
          ledOn(leds[i]);
          delay(100000);
        }
      for (i = 0; i < NUM_LEDS; ++i)
        {
          ledOff(leds[i]);
          delay(100000);
        }
      for (i = NUM_LEDS - 1; i >= 0; --i)
        {
          ledOn(leds[i]);
          delay(100000);
        }
      for (i = NUM_LEDS - 1; i >= 0; --i)
        {
          ledOff(leds[i]);
          delay(100000);
        }

    }
  return 0;
}
