// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
////////////////////////////////////////////////////////////////////////////////
//
//                 ARM Evaluator-7T Interrupt Example
//
// Description
// -----------
// This example demonstrates a simple interrupt handler. When running, pressing
// the "USER INT0" button causes the irq_handler to execute which toggles
// the LEDs.
//
////////////////////////////////////////////////////////////////////////////////

#include "__armlib.h"
#include <targets/S3C4510B.h>
                                             
#define IO_RISING_EDGE_INT0	(1 << 0)
#define IO_ENABLE_INT0		(1 << 4)
#define IO_ACTIVE_HIGH_INT0	(1 << 3)

static void
toggleLED()
{      
  IOPDATA ^= 0xFFFFFFFF;
}                 

void irq_handler(void) __attribute__ ((interrupt ("IRQ")));

void
irq_handler(void)
{
  INTPND = 1;
  toggleLED();
}
          
int
main(int argc, const char *argv[])
{
  unsigned int v;

  IOPMOD = 0x1FCF0;

  __ARMLIB_enableIRQ();

  IOPCON |= IO_ENABLE_INT0;              // enable int0
  IOPCON |= IO_ACTIVE_HIGH_INT0;         // set as active high
  IOPCON |= IO_RISING_EDGE_INT0;         // allow for RISING EDGE  
  INTPND = 1;
  INTMSK &= ~0x00200001;         
 
  while(1)
    v++;
  
  return 0;
}
