// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "test.h"
#include <ctl_api.h>

CTL_TASK_t mainTask, otherTask;
unsigned otherStack[64];
unsigned e1=0;
unsigned count = 0;
unsigned count2 = 0;

#define BUTTON_EVENT (1<<0)
#define TIMER_EVENT (1<<1)

void 
buttonPressedISR(void)
{
  count++;
  ctl_set_clear_events(&e1, BUTTON_EVENT, 0);
}

void
timerISR(void)
{
  count2++;
  ctl_set_clear_events(&e1, TIMER_EVENT, 0);
}

void 
other(void *p)
{
  while (1)
    {
      unsigned w=ctl_task_wait(CTL_STATE_EVENT_WAIT|CTL_STATE_EVENT_ANY_NOT_ALL, 0, &e1, BUTTON_EVENT|TIMER_EVENT);
      if (w & BUTTON_EVENT)
      {
        ctl_set_clear_events(&e1, 0, BUTTON_EVENT);
        SetLeds(0);
      }
      else if (w & TIMER_EVENT)
      {
        ctl_set_clear_events(&e1, 0, TIMER_EVENT);
        if ((count2 % 5000)==0)      
          SetLeds(0xffffffff);          
      }
      else
        ; // error case
    }
}

void
ctl_handle_error(CTL_ERROR_CODE_t e)
{
  while (1);
}

int main(void)
{
  unsigned int v=0;
  BoardInit();
  ctl_task_init(&mainTask, 0, "main");  
  ctl_task_run(&otherTask, 1, other, 0, "other", sizeof(otherStack)/sizeof(unsigned), otherStack);
  SetTimerISR(timerISR);
  SetButtonPressedISR(buttonPressedISR);
  while (1)
    Idle();
  return 0;
}
