// ARM runtime support.
//
// Copyright (c) 2001, 2002 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef __armlib_H
#define __armlib_H

#ifdef __cplusplus
extern "C" {
#endif
                            
/*****************************************************************************
 * Function    : __ARMLIB_enableIRQ                                          *
 * Description : Enable ARM's global interrupts                              *
 *****************************************************************************/
void __ARMLIB_enableIRQ(void);

/*****************************************************************************
 * Function    : __ARMLIB_disableIRQ                                         *
 * Description : Disable ARM's global interrupts                             *
 *****************************************************************************/
void __ARMLIB_disableIRQ(void);

/*****************************************************************************
 * Function    : __ARMLIB_enableFIQ                                          *
 * Description : Enable ARM's global interrupts                              *
 *****************************************************************************/
void __ARMLIB_enableFIQ(void);

/*****************************************************************************
 * Function    : __ARMLIB_disableFIQ                                         *
 * Description : Disable ARM's global interrupts                             *
 *****************************************************************************/
void __ARMLIB_disableFIQ(void);

/*****************************************************************************
 * Function    : __ARMLIB_commTX                                             *
 * Description : Transmit word down the ARM's communication channel.         *
 *****************************************************************************/
void __ARMLIB_commTX(unsigned long n);

/*****************************************************************************
 * Function    : __ARMLIB_commRX                                             *
 * Description : Receive word fom the ARM's communication channel.           *
 *****************************************************************************/
unsigned long __ARMLIB_commRX(void);

/*****************************************************************************
 * Function    : __ARMLIB_runCommPortServer                                  *
 * Description : Serve commands from ARM's communication channel until       *
 *               terminated.                                                 *
 *****************************************************************************/
void __ARMLIB_runCommPortServer(void);

#ifdef __cplusplus
}
#endif

#endif

