// CrossWorks Tasking Library.
//
// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

function getState(state)
{
  if (state==0)
    return "runnable";
  else if (state==128)
    return "finished"
  else if ((state & 3)==3)
    return "event & timer wait";
  else if ((state & 1)==1)      
    return "timer wait";
  else if ((state & 2)==2)     
    return "event wait";
  else
    return "invalid";
}

function getregs(sp)
{
  var a = new Array();
  a[16] = Debug.evaluate("*(unsigned*)0x"+sp.toString(16)); 
  sp+=4;
  for (i=0;i<13;i++)
    {
      a[i] = Debug.evaluate("*(unsigned*)0x"+sp.toString(16)); 
      sp+=4;
    }
  a[14] = Debug.evaluate("*(unsigned*)0x"+sp.toString(16)); 
  sp+=4;
  a[15] = Debug.evaluate("*(unsigned*)0x"+sp.toString(16));
  sp+=4;
  a[13] = sp;
  return a;
}

function update() 
{
  Threads.clear();
  var x=Debug.evaluate("ctl_task_executing");
  if (x)
    {
      Threads.newqueue("Executing");
      x = Debug.evaluate("*(CTL_TASK_t*)"+x);
      Threads.add(x.name, x.priority, "executing", []);
    }
  x=Debug.evaluate("ctl_task_list");
  if (x)
    Threads.newqueue("Waiting");
  var count=0;
  while (x && count<10)
    {
      x = Debug.evaluate("*(CTL_TASK_t*)"+x);         
      Threads.add(x.name, x.priority, getState(x.state), getregs(x.stack_pointer));
      x=x.next;
      count++;
    }
}
