/*****************************************************************************
 * ARM Loader - Main Loop                                                    *
 *                                                                           *
 * Copyright (c) 2003 Rowley Associates Limited.                             *
 *                                                                           *
 * This file may be distributed under the terms of the License Agreement     *
 * provided with this software.                                              *
 *                                                                           *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE   *
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. *
 *****************************************************************************/

#include "__armcps.h"
#include "loader.h"

static void
loaderMain(void)
{
  for(;;)
    {
      unsigned int ctrl, length;
      loaderWaitForCommand();                   
      ctrl = loaderReadWord(); 
      length = ctrl >> __CPS_CTRL_LENGTH_OFFSET;
      switch(ctrl & __CPS_CTRL_TAG_MASK)
        {
          case __CPS_TAG_POKE:
            loaderWriteWord(loaderPoke((unsigned char *)loaderReadWord(), length));
            break;
          case __CPS_TAG_PEEK:
            loaderWriteWord(loaderPeek((unsigned char *)loaderReadWord(), length));
            break;
          case __CPS_TAG_VERIFY:
            loaderWriteWord(loaderVerify((unsigned char *)loaderReadWord(), length));
            break;
          case __CPS_TAG_MEMSET:
            loaderWriteWord(loaderMemset((unsigned char *)loaderReadWord(), length, (unsigned char)loaderReadWord()));
            break;
          case __CPS_TAG_ERASE:
            loaderWriteWord(loaderErase((unsigned char *)loaderReadWord(), length));
            break;
          case __CPS_TAG_ERASE_ALL:
            loaderWriteWord(loaderEraseAll());
            break;
          case __CPS_TAG_SET_PARAM:
            loaderWriteWord(loaderSetParameter(loaderReadWord(), loaderReadWord()));
            break;
          case __CPS_TAG_TERMINATE:
            return;
        }
    }
}

void
C_Entry(void)
{
  loaderBegin();
  loaderMain();
  loaderEnd();
}
