function STA2051_Reset()
{
  TargetInterface.setNSRST(0);
  TargetInterface.setICEBreakerBreakpoint(0, 0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x100, 0xF7);
  TargetInterface.setNSRST(1);
  TargetInterface.waitForDebugState(1000);
  TargetInterface.trst();
  // Reset the GPS engine
  TargetInterface.pokeWord(0xA0000048, 0x1);
  TargetInterface.pokeWord(0xA0000048, 0x0);
  // Reset UARTS
  TargetInterface.pokeWord(0xC0000014, 0x78);
  TargetInterface.pokeWord(0xC0000014, 0x0);
  // Reset EIC, TIMERS 0-3
  TargetInterface.pokeWord(0xE0000014, 0x4800);
  TargetInterface.pokeWord(0xE0000014, 0x0);
  // Reset the GPS correlator
  TargetInterface.pokeWord(0x8000F014, 0x1);
  TargetInterface.pokeWord(0x8000F014, 0x0);
}

function STA2051_ResetWithRamAtZero()
{
  STA2051_Reset();
  TargetInterface.pokeWord(0xA0000050, 0x1c2); // Map RAM at Zero 
}

function STA2051_ResetWithFlashAtZero()
{
  STA2051_Reset();
  TargetInterface.pokeWord(0xA0000050, 0x1c0); // Map FLASH at Zero 
}

