/*****************************************************************************
 * Copyright (c) 2004 Rowley Associates Limited.                             *
 *                                                                           *
 * This file may be distributed under the terms of the License Agreement     *
 * provided with this software.                                              *
 *                                                                           *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE   *
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. *
 *****************************************************************************/

  .section .vectors, "ax"
  .code 32
  .align 0

/*****************************************************************************
 * Exception Vectors                                                         *
 *****************************************************************************/
_vectors:
  ldr pc, [pc, #reset_handler_address - . - 8] /* reset */
  ldr pc, [pc, #undef_handler_address - . - 8] /* undefined instruction */
  ldr pc, [pc, #swi_handler_address - . - 8] /* swi handler */
  ldr pc, [pc, #pabort_handler_address - . - 8] /* abort prefetch */
  ldr pc, [pc, #dabort_handler_address - . - 8] /* abort data */
  nop
  ldr pc, [pc, #irq_handler_address - . - 8]
  ldr pc, [pc, #fiq_handler_address - . - 8]

reset_handler_address:
  .word reset_handler
undef_handler_address:
  .word undef_handler
swi_handler_address:
  .word swi_handler
pabort_handler_address:
  .word pabort_handler
dabort_handler_address:
  .word dabort_handler
irq_handler_address:
  .word irq_handler
fiq_handler_address:
  .word fiq_handler

  .section .init, "ax"
  .code 32
  .align 0

/******************************************************************************
 *                                                                            *
 * Default exception handlers                                                 *
 *                                                                            *
 ******************************************************************************/
reset_handler:
  bl init_sys_clk

  /* r1 = 0xFFFF1000 */
  mov r1, #0x88000000
  mov r1, r1, asr #0xf 

  /* BCR0 */
  mov r0, #0x10000000
  add r0, r0, #0x2D00
  add r0, r0, #0x0003
  str r0, [r1, #0x0] 

  /* BCR2 */
  mov r0, #0x10000000
  add r0, r0, #0x0C00
  add r0, r0, #0x0021
  str r0, [r1, #0x8] 

  /* r1 = 0xFFFE5000 */
  mov r1, #0x94000000
  mov r1, r1, asr #0xe 

  /* EBI_MUX */
  mov r0, #0x7F00
  add r0, r0, #0xFF
  str r0, [r1, #0]

#ifdef __FLASH_BUILD
  /* Copy exception vectors into Internal SRAM */
  mov r8, #0x60000000
  ldr r9, =_vectors
  ldmia r9!, {r0-r7}
  stmia r8!, {r0-r7}
  ldmia r9!, {r0-r6}
  stmia r8!, {r0-r6}

  /* r1 = 0xfffe2000 */
  mov r1, #0x88000000
  mov r1, r1, asr #0xe 

  /* Remap Internal SRAM to 0x00000000 */
  mov r0, #0x2
  str r0, [r1, #8]
#endif
  /* Jump to the default C runtime startup code. */
  b _start

/* Setup the system clocks to 51.6Mhz.
*/
init_sys_clk:
  /* r1 = 0xfffe2000 */
  mov r1, #0x88000000
  mov r1, r1, asr #0xe 
  mov r0, #1
  str r0, [r1, #0x18] /* SysClkPrescale: divider = 2 */
  mov pc, lr

/******************************************************************************
 *                                                                            *
 * Default exception handlers                                                 *
 * These are declared weak symbols so they can be redefined in user code.     * 
 *                                                                            *
 ******************************************************************************/

undef_handler:
  b undef_handler
  
swi_handler:
  b swi_handler
  
pabort_handler:
  b pabort_handler
  
dabort_handler:
  b dabort_handler
  
irq_handler:
  b irq_handler
  
fiq_handler:
  b fiq_handler

  .weak undef_handler, swi_handler, pabort_handler, dabort_handler, irq_handler, fiq_handler

