/*****************************************************************************
 * Copyright (c) 2001, 2002 Rowley Associates Limited.                       *
 *                                                                           *
 * This file may be distributed under the terms of the License Agreement     *
 * provided with this software.                                              *
 *                                                                           *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE   *
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. *
 *****************************************************************************/

  .section .vectors, "ax"
  .code 32
  .align 0

#ifdef __FLASH_BUILD

/*****************************************************************************
 * Exception Vectors (Prior to remap)                                        *
 *****************************************************************************/
_pre_remap_vectors:
  b configure_and_start 
  b undef_handler
  b swi_handler
  b pabort_handler
  b dabort_handler
  .word 0 
  b irq_handler
  b fiq_handler

#endif

/*****************************************************************************
 * Exception Vectors (Post remap)                                            *
 *****************************************************************************/
_vectors:
  ldr pc, [pc, #reset_handler_address - . - 8] /* reset */
  ldr pc, [pc, #undef_handler_address - . - 8] /* undefined instruction */
  ldr pc, [pc, #swi_handler_address - . - 8] /* swi handler */
  ldr pc, [pc, #pabort_handler_address - . - 8] /* abort prefetch */
  ldr pc, [pc, #dabort_handler_address - . - 8] /* abort data */
  nop
  ldr pc, [pc, #irq_handler_address - . - 8] /* irq */
  ldr pc, [pc, #fiq_handler_address - . - 8] /* fiq */

_exception_entrypoints:
reset_handler_address:
  .word _start
undef_handler_address:
  .word undef_handler
swi_handler_address:
  .word swi_handler
pabort_handler_address:
  .word pabort_handler
dabort_handler_address:
  .word dabort_handler
irq_handler_address:
  .word irq_handler
fiq_handler_address:
  .word fiq_handler

  .section .init, "ax"
  .code 32
  .align 0

#ifdef __FLASH_BUILD

/*****************************************************************************
 * Function    : configure_and_start                                         *
 * Description : Configure memory and jump to the _start entrypoint.         *
 *****************************************************************************/

configure_and_start:
  /* Copy exception vectors */
  mov r8, #0x00300000 /* Address of SRAM prior to remap */
  mov r9, #(_vectors - _pre_remap_vectors) /* Address of _vectors in FLASH prior 
                                              to remap (FLASH at 0x00000000) */
  ldmia r9!, {r0-r7}
  stmia r8!, {r0-r7}
  ldmia r9!, {r0-r6}
  stmia r8!, {r0-r6}
          
  /* Configure memory */
  sub r10, pc, #(+.-memory_configuration+8)
  ldr r12, =_start
  ldmia r10!, {r0-r9, r11}
  stmia r11!, {r0-r9}
      
  /* Leap to the main entry point */
  mov pc, r12
                  
/******************************************************************************
 * Register settings for the following memory configuration:                  *
 *                                                                            *
 *     ------------------                                                     *
 *    |      FLASH       | 0x01000000 - 0x011FFFFF                            *
 *    |------------------|                                                    *
 *    |      SRAM        | 0x00000000 - 0x0003FFFF                            *
 *     ------------------                                                     *
 *                                                                            *
 ******************************************************************************/

memory_configuration:
  .word 0x01002539 // EBI_CSR0
  .word 0x10000000 // EBI_CSR1
  .word 0x20000000 // EBI_CSR2
  .word 0x30000000 // EBI_CSR3
  .word 0x40000000 // EBI_CSR4
  .word 0x50000000 // EBI_CSR5
  .word 0x60000000 // EBI_CSR6
  .word 0x70000000 // EBI_CSR7
  .word 0x00000001 // EBI_RCR (remap command)
  .word 0x00000006 // EBI_MCR (6 memory regions, standard read)
  .word 0xFFE00000 // EBI Base Address

#endif

/******************************************************************************
 *                                                                            *
 * Default exception handlers                                                 *
 * These are declared weak symbols so they can be redefined in user code.     * 
 *                                                                            *
 ******************************************************************************/

undef_handler:
  b undef_handler
  
swi_handler:
  b swi_handler
  
pabort_handler:
  b pabort_handler
  
dabort_handler:
  b dabort_handler
  
irq_handler:
  b irq_handler
  
fiq_handler:
  b fiq_handler

  .weak undef_handler, swi_handler, pabort_handler, dabort_handler, irq_handler, fiq_handler
