/*****************************************************************************
 * Copyright (c) 2001, 2002 Rowley Associates Limited.                       *
 *                                                                           *
 * This file may be distributed under the terms of the License Agreement     *
 * provided with this software.                                              *
 *                                                                           *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE   *
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. *
 *****************************************************************************/
  .section .vectors, "ax"
  .code 32
  .align 0

  .global _start
  .extern C_Entry
  .global stack_start
  .global stack_end

/*****************************************************************************
 * Minimal set of exception handlers which will be in place once memory      *
 * has been remapped.                                                        *
 *****************************************************************************/
reset_handler:
  b configure_memory
undef_handler:
  b undef_handler
swi_handler:  
  b swi_handler
pabort_handler:
  b pabort_handler
dabort_handler:
  b dabort_handler
  .word 0
irq_handler:
  b irq_handler
fiq_handler:
  b fiq_handler

  .text
  .code 32
  
/*****************************************************************************
 * Configure the memory the same as the final running system so that all the *
 * load addresses are correct.                                               *
 *****************************************************************************/
configure_memory:
  ldr r0, SYSCFG
  ldr r1, SYSCFG_val
  str r1, [r0]

  ldr lr, =_start
  sub r0, pc, #(+.-memory_configuration+8)
  ldmia r0, {r0-r12}
  stmia r0, {r1-r12}
  mov pc, lr
                  
/*****************************************************************************
 * Register settings for the following memory configuration:                 *
 *                                                                           *
 *                     ----------------------                                *
 *                    | ROMCON0 - 512K FLASH | 0x01800000 - 0x0187FFFF       *
 *                    |----------------------|                               *
 *                    | ROMCON2 - 256K SRAM  | 0x00040000 - 0x0007FFFF       *
 *                    |----------------------|                               *
 *                    | ROMCON1 - 256K SRAM  | 0x00000000 - 0x0003FFFF       *
 *                     ----------------------                                *
 *                                                                           *
 *****************************************************************************/
memory_configuration:
  .word 0x03FF3010 // &EXTDBWIDTH
  .word 0x0000003E // EXTDBWIDTH
  .word 0x18860030 // ROMCON0
  .word 0x00400010 // ROMCON1
  .word 0x00801010 // ROMCON2
  .word 0x08018020 // ROMCON3
  .word 0x0A020040 // ROMCON4
  .word 0x0C028040 // ROMCON5
  .word 0x00000000 // DRAMCON0
  .word 0x00000000 // DRAMCON1
  .word 0x00000000 // DRAMCON2
  .word 0x00000000 // DRAMCON3
  .word 0x9C218360 // REFEXTCON

SYSCFG:
  .word 0x03FF0000 // &SYSCFG
SYSCFG_val:
  .word 0x03FFFFA0 // SYSCFG

/*****************************************************************************
 * Function    : _start                                                      *
 * Description : Minimal startup code for C system.                          *
 *****************************************************************************/
_start:                         
  /* Setup stack */ 
  add sp, pc, #1024 
  
  /* Jump to main entry point */
  bl C_Entry

  /* Return from main, loop forever. */
loop:
  b loop
                          
stack_start:
  .fill 1024
stack_end:
                  
